/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v23.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 CD (Channel Definition (2.8.2)) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>channel identifier (CM_WVI)
 * <li>electrode names (CM_CD_ELECTRODE)
 * <li>channel sensitivity/units (CM_CSU)
 * <li>calibration parameters (CM_CCP)
 * <li>sampling frequency (NM)
 * <li>minimum/maximum data values (CM_MDV)
 * </ul>
 */
public class CD extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new CD type
     */
    public CD(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[6];    
        data[0] = new CM_WVI(getMessage());
        data[1] = new CM_CD_ELECTRODE(getMessage());
        data[2] = new CM_CSU(getMessage());
        data[3] = new CM_CCP(getMessage());
        data[4] = new NM(getMessage());
        data[5] = new CM_MDV(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns channel identifier (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CM_WVI getChannelIdentifier() {
       CM_WVI ret = null;
       try {
          ret = (CM_WVI)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns channel identifier (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CM_WVI getCd1_ChannelIdentifier() {
       CM_WVI ret = null;
       try {
          ret = (CM_WVI)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns electrode names (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CM_CD_ELECTRODE getElectrodeNames() {
       CM_CD_ELECTRODE ret = null;
       try {
          ret = (CM_CD_ELECTRODE)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns electrode names (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CM_CD_ELECTRODE getCd2_ElectrodeNames() {
       CM_CD_ELECTRODE ret = null;
       try {
          ret = (CM_CD_ELECTRODE)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns channel sensitivity/units (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CM_CSU getChannelSensitivityUnits() {
       CM_CSU ret = null;
       try {
          ret = (CM_CSU)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns channel sensitivity/units (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CM_CSU getCd3_ChannelSensitivityUnits() {
       CM_CSU ret = null;
       try {
          ret = (CM_CSU)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns calibration parameters (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CM_CCP getCalibrationParameters() {
       CM_CCP ret = null;
       try {
          ret = (CM_CCP)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns calibration parameters (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CM_CCP getCd4_CalibrationParameters() {
       CM_CCP ret = null;
       try {
          ret = (CM_CCP)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns sampling frequency (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getSamplingFrequency() {
       NM ret = null;
       try {
          ret = (NM)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns sampling frequency (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getCd5_SamplingFrequency() {
       NM ret = null;
       try {
          ret = (NM)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns minimum/maximum data values (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CM_MDV getMinimumMaximumDataValues() {
       CM_MDV ret = null;
       try {
          ret = (CM_MDV)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns minimum/maximum data values (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CM_MDV getCd6_MinimumMaximumDataValues() {
       CM_MDV ret = null;
       try {
          ret = (CM_MDV)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

