/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v23.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 CM_ABS_RANGE (absolute range) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>Range (CM_RANGE)
 * <li>Numeric Change (NM)
 * <li>Percent per Change (NM)
 * <li>Days (NM)
 * </ul>
 */
public class CM_ABS_RANGE extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new CM_ABS_RANGE type
     */
    public CM_ABS_RANGE(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[4];    
        data[0] = new CM_RANGE(getMessage());
        data[1] = new NM(getMessage());
        data[2] = new NM(getMessage());
        data[3] = new NM(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns Range (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CM_RANGE getRange() {
       CM_RANGE ret = null;
       try {
          ret = (CM_RANGE)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Range (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CM_RANGE getCm_abs_range1_Range() {
       CM_RANGE ret = null;
       try {
          ret = (CM_RANGE)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Numeric Change (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getNumericChange() {
       NM ret = null;
       try {
          ret = (NM)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Numeric Change (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getCm_abs_range2_NumericChange() {
       NM ret = null;
       try {
          ret = (NM)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Percent per Change (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getPercentPerChange() {
       NM ret = null;
       try {
          ret = (NM)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Percent per Change (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getCm_abs_range3_PercentPerChange() {
       NM ret = null;
       try {
          ret = (NM)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Days (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getDays() {
       NM ret = null;
       try {
          ret = (NM)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Days (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getCm_abs_range4_Days() {
       NM ret = null;
       try {
          ret = (NM)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

