/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v23.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 CM_OSD (order sequence) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>sequence/results flag (ID)
 * <li>placer order number entity identifier (ST)
 * <li>placer order number namespace ID (IS)
 * <li>filler order number entity identifier (ST)
 * <li>filler order number namespace ID (IS)
 * <li>sequence condition value (ST)
 * <li>maximum number of repeats (NM)
 * <li>placer order number universal ID (ST)
 * <li>placer order number universal ID type (ID)
 * <li>filler order number universal ID (ST)
 * <li>filler order number universal ID type (ID)
 * </ul>
 */
public class CM_OSD extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new CM_OSD type
     */
    public CM_OSD(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[11];    
        data[0] = new ID(getMessage(), 0);
        data[1] = new ST(getMessage());
        data[2] = new IS(getMessage(), 0);
        data[3] = new ST(getMessage());
        data[4] = new IS(getMessage(), 0);
        data[5] = new ST(getMessage());
        data[6] = new NM(getMessage());
        data[7] = new ST(getMessage());
        data[8] = new ID(getMessage(), 0);
        data[9] = new ST(getMessage());
        data[10] = new ID(getMessage(), 0);
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns sequence/results flag (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getSequenceResultsFlag() {
       ID ret = null;
       try {
          ret = (ID)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns sequence/results flag (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCm_osd1_SequenceResultsFlag() {
       ID ret = null;
       try {
          ret = (ID)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns placer order number entity identifier (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getPlacerOrderNumberEntityIdentifier() {
       ST ret = null;
       try {
          ret = (ST)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns placer order number entity identifier (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCm_osd2_PlacerOrderNumberEntityIdentifier() {
       ST ret = null;
       try {
          ret = (ST)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns placer order number namespace ID (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getPlacerOrderNumberNamespaceID() {
       IS ret = null;
       try {
          ret = (IS)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns placer order number namespace ID (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getCm_osd3_PlacerOrderNumberNamespaceID() {
       IS ret = null;
       try {
          ret = (IS)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns filler order number entity identifier (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getFillerOrderNumberEntityIdentifier() {
       ST ret = null;
       try {
          ret = (ST)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns filler order number entity identifier (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCm_osd4_FillerOrderNumberEntityIdentifier() {
       ST ret = null;
       try {
          ret = (ST)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns filler order number namespace ID (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getFillerOrderNumberNamespaceID() {
       IS ret = null;
       try {
          ret = (IS)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns filler order number namespace ID (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getCm_osd5_FillerOrderNumberNamespaceID() {
       IS ret = null;
       try {
          ret = (IS)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns sequence condition value (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getSequenceConditionValue() {
       ST ret = null;
       try {
          ret = (ST)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns sequence condition value (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCm_osd6_SequenceConditionValue() {
       ST ret = null;
       try {
          ret = (ST)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns maximum number of repeats (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getMaximumNumberOfRepeats() {
       NM ret = null;
       try {
          ret = (NM)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns maximum number of repeats (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getCm_osd7_MaximumNumberOfRepeats() {
       NM ret = null;
       try {
          ret = (NM)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns placer order number universal ID (component #8).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getPlacerOrderNumberUniversalID() {
       ST ret = null;
       try {
          ret = (ST)getComponent(7);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns placer order number universal ID (component #8).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCm_osd8_PlacerOrderNumberUniversalID() {
       ST ret = null;
       try {
          ret = (ST)getComponent(7);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns placer order number universal ID type (component #9).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getPlacerOrderNumberUniversalIDType() {
       ID ret = null;
       try {
          ret = (ID)getComponent(8);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns placer order number universal ID type (component #9).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCm_osd9_PlacerOrderNumberUniversalIDType() {
       ID ret = null;
       try {
          ret = (ID)getComponent(8);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns filler order number universal ID (component #10).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getFillerOrderNumberUniversalID() {
       ST ret = null;
       try {
          ret = (ST)getComponent(9);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns filler order number universal ID (component #10).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCm_osd10_FillerOrderNumberUniversalID() {
       ST ret = null;
       try {
          ret = (ST)getComponent(9);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns filler order number universal ID type (component #11).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getFillerOrderNumberUniversalIDType() {
       ID ret = null;
       try {
          ret = (ID)getComponent(10);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns filler order number universal ID type (component #11).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCm_osd11_FillerOrderNumberUniversalIDType() {
       ID ret = null;
       try {
          ret = (ID)getComponent(10);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

