/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v23.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 CM_PRL (parent result link) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>OBX-3 observation identifier of parent result (CE)
 * <li>OBX-4 sub-ID of parent result (ST)
 * <li>part of OBX-5 observation result from parent (TX)
 * </ul>
 */
public class CM_PRL extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new CM_PRL type
     */
    public CM_PRL(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[3];    
        data[0] = new CE(getMessage());
        data[1] = new ST(getMessage());
        data[2] = new TX(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns OBX-3 observation identifier of parent result (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CE getOBX3ObservationIdentifierOfParentResult() {
       CE ret = null;
       try {
          ret = (CE)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns OBX-3 observation identifier of parent result (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CE getCm_prl1_OBX3ObservationIdentifierOfParentResult() {
       CE ret = null;
       try {
          ret = (CE)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns OBX-4 sub-ID of parent result (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getOBX4SubIDOfParentResult() {
       ST ret = null;
       try {
          ret = (ST)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns OBX-4 sub-ID of parent result (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCm_prl2_OBX4SubIDOfParentResult() {
       ST ret = null;
       try {
          ret = (ST)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns part of OBX-5 observation result from parent (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TX getPartOfOBX5ObservationResultFromParent() {
       TX ret = null;
       try {
          ret = (TX)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns part of OBX-5 observation result from parent (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TX getCm_prl3_PartOfOBX5ObservationResultFromParent() {
       TX ret = null;
       try {
          ret = (TX)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

