/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v23.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 MA (multiplexed array) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>sample 1 from channel 1 (NM)
 * <li>sample 1 from channel 2 (NM)
 * <li>sample 1 from channel 3 (NM)
 * <li>sample 2 from channel 1 (NM)
 * <li>sample 2 from channel 2 (NM)
 * <li>sample 2 from channel 3 (NM)
 * </ul>
 */
public class MA extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new MA type
     */
    public MA(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[6];    
        data[0] = new NM(getMessage());
        data[1] = new NM(getMessage());
        data[2] = new NM(getMessage());
        data[3] = new NM(getMessage());
        data[4] = new NM(getMessage());
        data[5] = new NM(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns sample 1 from channel 1 (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getSample1FromChannel1() {
       NM ret = null;
       try {
          ret = (NM)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns sample 1 from channel 1 (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getMa1_Sample1FromChannel1() {
       NM ret = null;
       try {
          ret = (NM)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns sample 1 from channel 2 (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getSample1FromChannel2() {
       NM ret = null;
       try {
          ret = (NM)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns sample 1 from channel 2 (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getMa2_Sample1FromChannel2() {
       NM ret = null;
       try {
          ret = (NM)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns sample 1 from channel 3 (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getSample1FromChannel3() {
       NM ret = null;
       try {
          ret = (NM)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns sample 1 from channel 3 (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getMa3_Sample1FromChannel3() {
       NM ret = null;
       try {
          ret = (NM)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns sample 2 from channel 1 (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getSample2FromChannel1() {
       NM ret = null;
       try {
          ret = (NM)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns sample 2 from channel 1 (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getMa4_Sample2FromChannel1() {
       NM ret = null;
       try {
          ret = (NM)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns sample 2 from channel 2 (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getSample2FromChannel2() {
       NM ret = null;
       try {
          ret = (NM)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns sample 2 from channel 2 (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getMa5_Sample2FromChannel2() {
       NM ret = null;
       try {
          ret = (NM)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns sample 2 from channel 3 (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getSample2FromChannel3() {
       NM ret = null;
       try {
          ret = (NM)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns sample 2 from channel 3 (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getMa6_Sample2FromChannel3() {
       NM ret = null;
       try {
          ret = (NM)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

