/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.model.v23.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a PEX_P07_ASSOCIATED_PERSON group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: NK1 (Next of kin) <b> </b></li>
                 * <li>2: PEX_P07_ASSOCIATED_RX_ORDER (a Group object) <b>optional </b></li>
                 * <li>3: PEX_P07_ASSOCIATED_RX_ADMIN (a Group object) <b>optional repeating</b></li>
                 * <li>4: PRB (Problem Detail) <b>optional repeating</b></li>
                 * <li>5: OBX (Observation segment) <b>optional repeating</b></li>
 * </ul>
 */
public class PEX_P07_ASSOCIATED_PERSON extends AbstractGroup {

    /** 
     * Creates a new PEX_P07_ASSOCIATED_PERSON group
     */
    public PEX_P07_ASSOCIATED_PERSON(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(NK1.class, true, false);
                          this.add(PEX_P07_ASSOCIATED_RX_ORDER.class, false, false);
                          this.add(PEX_P07_ASSOCIATED_RX_ADMIN.class, false, true);
                          this.add(PRB.class, false, true);
                          this.add(OBX.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PEX_P07_ASSOCIATED_PERSON - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3"
     */
    public String getVersion() {
       return "2.3";
    }



    /**
     * Returns
     * NK1 (Next of kin) - creates it if necessary
     */
    public NK1 getNK1() { 
       NK1 ret = null;
       try {
          ret = (NK1)this.get("NK1");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * ASSOCIATED_RX_ORDER (a Group object) - creates it if necessary
     */
    public PEX_P07_ASSOCIATED_RX_ORDER getASSOCIATED_RX_ORDER() { 
       PEX_P07_ASSOCIATED_RX_ORDER ret = null;
       try {
          ret = (PEX_P07_ASSOCIATED_RX_ORDER)this.get("ASSOCIATED_RX_ORDER");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * ASSOCIATED_RX_ADMIN (a Group object) - creates it if necessary
     */
    public PEX_P07_ASSOCIATED_RX_ADMIN getASSOCIATED_RX_ADMIN() { 
       PEX_P07_ASSOCIATED_RX_ADMIN ret = null;
       try {
          ret = (PEX_P07_ASSOCIATED_RX_ADMIN)this.get("ASSOCIATED_RX_ADMIN");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ASSOCIATED_RX_ADMIN (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public PEX_P07_ASSOCIATED_RX_ADMIN getASSOCIATED_RX_ADMIN(int rep) { 
       PEX_P07_ASSOCIATED_RX_ADMIN ret = null;
       try {
          ret = (PEX_P07_ASSOCIATED_RX_ADMIN)this.get("ASSOCIATED_RX_ADMIN", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ASSOCIATED_RX_ADMIN 
     */ 
    public int getASSOCIATED_RX_ADMINReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ASSOCIATED_RX_ADMIN").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ASSOCIATED_RX_ADMIN (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertASSOCIATED_RX_ADMIN(PEX_P07_ASSOCIATED_RX_ADMIN structure, int rep) throws HL7Exception { 
       super.insertRepetition("ASSOCIATED_RX_ADMIN", structure, rep);
    }


    /**
     * Inserts a specific repetition of ASSOCIATED_RX_ADMIN (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public PEX_P07_ASSOCIATED_RX_ADMIN insertASSOCIATED_RX_ADMIN(int rep) throws HL7Exception { 
       return (PEX_P07_ASSOCIATED_RX_ADMIN)super.insertRepetition("ASSOCIATED_RX_ADMIN", rep);
    }


    /**
     * Removes a specific repetition of ASSOCIATED_RX_ADMIN (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public PEX_P07_ASSOCIATED_RX_ADMIN removeASSOCIATED_RX_ADMIN(int rep) throws HL7Exception { 
       return (PEX_P07_ASSOCIATED_RX_ADMIN)super.removeRepetition("ASSOCIATED_RX_ADMIN", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * PRB (Problem Detail) - creates it if necessary
     */
    public PRB getPRB() { 
       PRB ret = null;
       try {
          ret = (PRB)this.get("PRB");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * PRB (Problem Detail) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public PRB getPRB(int rep) { 
       PRB ret = null;
       try {
          ret = (PRB)this.get("PRB", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of PRB 
     */ 
    public int getPRBReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("PRB").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of PRB (Problem Detail)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertPRB(PRB structure, int rep) throws HL7Exception { 
       super.insertRepetition("PRB", structure, rep);
    }


    /**
     * Inserts a specific repetition of PRB (Problem Detail)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public PRB insertPRB(int rep) throws HL7Exception { 
       return (PRB)super.insertRepetition("PRB", rep);
    }


    /**
     * Removes a specific repetition of PRB (Problem Detail)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public PRB removePRB(int rep) throws HL7Exception { 
       return (PRB)super.removeRepetition("PRB", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * OBX (Observation segment) - creates it if necessary
     */
    public OBX getOBX() { 
       OBX ret = null;
       try {
          ret = (OBX)this.get("OBX");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * OBX (Observation segment) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public OBX getOBX(int rep) { 
       OBX ret = null;
       try {
          ret = (OBX)this.get("OBX", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of OBX 
     */ 
    public int getOBXReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("OBX").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of OBX (Observation segment)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertOBX(OBX structure, int rep) throws HL7Exception { 
       super.insertRepetition("OBX", structure, rep);
    }


    /**
     * Inserts a specific repetition of OBX (Observation segment)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public OBX insertOBX(int rep) throws HL7Exception { 
       return (OBX)super.insertRepetition("OBX", rep);
    }


    /**
     * Removes a specific repetition of OBX (Observation segment)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public OBX removeOBX(int rep) throws HL7Exception { 
       return (OBX)super.removeRepetition("OBX", rep);
    }



}

