/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.model.v23.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a PEX_P07_STUDY group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: CSR (Clinical Study Registration) <b> </b></li>
                 * <li>2: CSP (Clinical Study Phase) <b>optional repeating</b></li>
 * </ul>
 */
public class PEX_P07_STUDY extends AbstractGroup {

    /** 
     * Creates a new PEX_P07_STUDY group
     */
    public PEX_P07_STUDY(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(CSR.class, true, false);
                          this.add(CSP.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PEX_P07_STUDY - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3"
     */
    public String getVersion() {
       return "2.3";
    }



    /**
     * Returns
     * CSR (Clinical Study Registration) - creates it if necessary
     */
    public CSR getCSR() { 
       CSR ret = null;
       try {
          ret = (CSR)this.get("CSR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * CSP (Clinical Study Phase) - creates it if necessary
     */
    public CSP getCSP() { 
       CSP ret = null;
       try {
          ret = (CSP)this.get("CSP");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * CSP (Clinical Study Phase) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public CSP getCSP(int rep) { 
       CSP ret = null;
       try {
          ret = (CSP)this.get("CSP", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of CSP 
     */ 
    public int getCSPReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("CSP").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of CSP (Clinical Study Phase)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertCSP(CSP structure, int rep) throws HL7Exception { 
       super.insertRepetition("CSP", structure, rep);
    }


    /**
     * Inserts a specific repetition of CSP (Clinical Study Phase)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public CSP insertCSP(int rep) throws HL7Exception { 
       return (CSP)super.insertRepetition("CSP", rep);
    }


    /**
     * Removes a specific repetition of CSP (Clinical Study Phase)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public CSP removeCSP(int rep) throws HL7Exception { 
       return (CSP)super.removeRepetition("CSP", rep);
    }



}

