/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.model.v23.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a RGV_O01_ORDER group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: ORC (Common order segment) <b> </b></li>
                 * <li>2: RGV_O01_ORDER_DETAIL (a Group object) <b>optional </b></li>
                 * <li>3: RGV_O01_ENCODING (a Group object) <b>optional </b></li>
                 * <li>4: RGV_O01_GIVE (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class RGV_O01_ORDER extends AbstractGroup {

    /** 
     * Creates a new RGV_O01_ORDER group
     */
    public RGV_O01_ORDER(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(ORC.class, true, false);
                          this.add(RGV_O01_ORDER_DETAIL.class, false, false);
                          this.add(RGV_O01_ENCODING.class, false, false);
                          this.add(RGV_O01_GIVE.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RGV_O01_ORDER - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3"
     */
    public String getVersion() {
       return "2.3";
    }



    /**
     * Returns
     * ORC (Common order segment) - creates it if necessary
     */
    public ORC getORC() { 
       ORC ret = null;
       try {
          ret = (ORC)this.get("ORC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * ORDER_DETAIL (a Group object) - creates it if necessary
     */
    public RGV_O01_ORDER_DETAIL getORDER_DETAIL() { 
       RGV_O01_ORDER_DETAIL ret = null;
       try {
          ret = (RGV_O01_ORDER_DETAIL)this.get("ORDER_DETAIL");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * ENCODING (a Group object) - creates it if necessary
     */
    public RGV_O01_ENCODING getENCODING() { 
       RGV_O01_ENCODING ret = null;
       try {
          ret = (RGV_O01_ENCODING)this.get("ENCODING");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * GIVE (a Group object) - creates it if necessary
     */
    public RGV_O01_GIVE getGIVE() { 
       RGV_O01_GIVE ret = null;
       try {
          ret = (RGV_O01_GIVE)this.get("GIVE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * GIVE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public RGV_O01_GIVE getGIVE(int rep) { 
       RGV_O01_GIVE ret = null;
       try {
          ret = (RGV_O01_GIVE)this.get("GIVE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of GIVE 
     */ 
    public int getGIVEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("GIVE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of GIVE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertGIVE(RGV_O01_GIVE structure, int rep) throws HL7Exception { 
       super.insertRepetition("GIVE", structure, rep);
    }


    /**
     * Inserts a specific repetition of GIVE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public RGV_O01_GIVE insertGIVE(int rep) throws HL7Exception { 
       return (RGV_O01_GIVE)super.insertRepetition("GIVE", rep);
    }


    /**
     * Removes a specific repetition of GIVE (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public RGV_O01_GIVE removeGIVE(int rep) throws HL7Exception { 
       return (RGV_O01_GIVE)super.removeRepetition("GIVE", rep);
    }



}

