/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.model.v23.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a SIU_S16_RESOURCES group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: RGS (Resource Group) <b> </b></li>
                 * <li>2: SIU_S16_SERVICE (a Group object) <b>optional repeating</b></li>
                 * <li>3: SIU_S16_GENERAL_RESOURCE (a Group object) <b>optional repeating</b></li>
                 * <li>4: SIU_S16_LOCATIONL_RESOURCE (a Group object) <b>optional repeating</b></li>
                 * <li>5: SIU_S16_PERSONNEL_RESOURCE (a Group object) <b>optional repeating</b></li>
 * </ul>
 */
public class SIU_S16_RESOURCES extends AbstractGroup {

    /** 
     * Creates a new SIU_S16_RESOURCES group
     */
    public SIU_S16_RESOURCES(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(RGS.class, true, false);
                          this.add(SIU_S16_SERVICE.class, false, true);
                          this.add(SIU_S16_GENERAL_RESOURCE.class, false, true);
                          this.add(SIU_S16_LOCATIONL_RESOURCE.class, false, true);
                          this.add(SIU_S16_PERSONNEL_RESOURCE.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating SIU_S16_RESOURCES - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3"
     */
    public String getVersion() {
       return "2.3";
    }



    /**
     * Returns
     * RGS (Resource Group) - creates it if necessary
     */
    public RGS getRGS() { 
       RGS ret = null;
       try {
          ret = (RGS)this.get("RGS");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * SERVICE (a Group object) - creates it if necessary
     */
    public SIU_S16_SERVICE getSERVICE() { 
       SIU_S16_SERVICE ret = null;
       try {
          ret = (SIU_S16_SERVICE)this.get("SERVICE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * SERVICE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SIU_S16_SERVICE getSERVICE(int rep) { 
       SIU_S16_SERVICE ret = null;
       try {
          ret = (SIU_S16_SERVICE)this.get("SERVICE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of SERVICE 
     */ 
    public int getSERVICEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("SERVICE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of SERVICE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertSERVICE(SIU_S16_SERVICE structure, int rep) throws HL7Exception { 
       super.insertRepetition("SERVICE", structure, rep);
    }


    /**
     * Inserts a specific repetition of SERVICE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public SIU_S16_SERVICE insertSERVICE(int rep) throws HL7Exception { 
       return (SIU_S16_SERVICE)super.insertRepetition("SERVICE", rep);
    }


    /**
     * Removes a specific repetition of SERVICE (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public SIU_S16_SERVICE removeSERVICE(int rep) throws HL7Exception { 
       return (SIU_S16_SERVICE)super.removeRepetition("SERVICE", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * GENERAL_RESOURCE (a Group object) - creates it if necessary
     */
    public SIU_S16_GENERAL_RESOURCE getGENERAL_RESOURCE() { 
       SIU_S16_GENERAL_RESOURCE ret = null;
       try {
          ret = (SIU_S16_GENERAL_RESOURCE)this.get("GENERAL_RESOURCE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * GENERAL_RESOURCE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SIU_S16_GENERAL_RESOURCE getGENERAL_RESOURCE(int rep) { 
       SIU_S16_GENERAL_RESOURCE ret = null;
       try {
          ret = (SIU_S16_GENERAL_RESOURCE)this.get("GENERAL_RESOURCE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of GENERAL_RESOURCE 
     */ 
    public int getGENERAL_RESOURCEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("GENERAL_RESOURCE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of GENERAL_RESOURCE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertGENERAL_RESOURCE(SIU_S16_GENERAL_RESOURCE structure, int rep) throws HL7Exception { 
       super.insertRepetition("GENERAL_RESOURCE", structure, rep);
    }


    /**
     * Inserts a specific repetition of GENERAL_RESOURCE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public SIU_S16_GENERAL_RESOURCE insertGENERAL_RESOURCE(int rep) throws HL7Exception { 
       return (SIU_S16_GENERAL_RESOURCE)super.insertRepetition("GENERAL_RESOURCE", rep);
    }


    /**
     * Removes a specific repetition of GENERAL_RESOURCE (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public SIU_S16_GENERAL_RESOURCE removeGENERAL_RESOURCE(int rep) throws HL7Exception { 
       return (SIU_S16_GENERAL_RESOURCE)super.removeRepetition("GENERAL_RESOURCE", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * LOCATIONL_RESOURCE (a Group object) - creates it if necessary
     */
    public SIU_S16_LOCATIONL_RESOURCE getLOCATIONL_RESOURCE() { 
       SIU_S16_LOCATIONL_RESOURCE ret = null;
       try {
          ret = (SIU_S16_LOCATIONL_RESOURCE)this.get("LOCATIONL_RESOURCE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * LOCATIONL_RESOURCE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SIU_S16_LOCATIONL_RESOURCE getLOCATIONL_RESOURCE(int rep) { 
       SIU_S16_LOCATIONL_RESOURCE ret = null;
       try {
          ret = (SIU_S16_LOCATIONL_RESOURCE)this.get("LOCATIONL_RESOURCE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of LOCATIONL_RESOURCE 
     */ 
    public int getLOCATIONL_RESOURCEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("LOCATIONL_RESOURCE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of LOCATIONL_RESOURCE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertLOCATIONL_RESOURCE(SIU_S16_LOCATIONL_RESOURCE structure, int rep) throws HL7Exception { 
       super.insertRepetition("LOCATIONL_RESOURCE", structure, rep);
    }


    /**
     * Inserts a specific repetition of LOCATIONL_RESOURCE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public SIU_S16_LOCATIONL_RESOURCE insertLOCATIONL_RESOURCE(int rep) throws HL7Exception { 
       return (SIU_S16_LOCATIONL_RESOURCE)super.insertRepetition("LOCATIONL_RESOURCE", rep);
    }


    /**
     * Removes a specific repetition of LOCATIONL_RESOURCE (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public SIU_S16_LOCATIONL_RESOURCE removeLOCATIONL_RESOURCE(int rep) throws HL7Exception { 
       return (SIU_S16_LOCATIONL_RESOURCE)super.removeRepetition("LOCATIONL_RESOURCE", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * PERSONNEL_RESOURCE (a Group object) - creates it if necessary
     */
    public SIU_S16_PERSONNEL_RESOURCE getPERSONNEL_RESOURCE() { 
       SIU_S16_PERSONNEL_RESOURCE ret = null;
       try {
          ret = (SIU_S16_PERSONNEL_RESOURCE)this.get("PERSONNEL_RESOURCE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * PERSONNEL_RESOURCE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SIU_S16_PERSONNEL_RESOURCE getPERSONNEL_RESOURCE(int rep) { 
       SIU_S16_PERSONNEL_RESOURCE ret = null;
       try {
          ret = (SIU_S16_PERSONNEL_RESOURCE)this.get("PERSONNEL_RESOURCE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of PERSONNEL_RESOURCE 
     */ 
    public int getPERSONNEL_RESOURCEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("PERSONNEL_RESOURCE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of PERSONNEL_RESOURCE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertPERSONNEL_RESOURCE(SIU_S16_PERSONNEL_RESOURCE structure, int rep) throws HL7Exception { 
       super.insertRepetition("PERSONNEL_RESOURCE", structure, rep);
    }


    /**
     * Inserts a specific repetition of PERSONNEL_RESOURCE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public SIU_S16_PERSONNEL_RESOURCE insertPERSONNEL_RESOURCE(int rep) throws HL7Exception { 
       return (SIU_S16_PERSONNEL_RESOURCE)super.insertRepetition("PERSONNEL_RESOURCE", rep);
    }


    /**
     * Removes a specific repetition of PERSONNEL_RESOURCE (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public SIU_S16_PERSONNEL_RESOURCE removePERSONNEL_RESOURCE(int rep) throws HL7Exception { 
       return (SIU_S16_PERSONNEL_RESOURCE)super.removeRepetition("PERSONNEL_RESOURCE", rep);
    }



}

