/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.model.v23.group.*;
import ca.uhn.hl7v2.model.v23.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a MFK_M01 message structure (see chapter ?). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (Message header segment) <b> </b></li>
                 * <li>2: MSA (Message acknowledgement segment) <b> </b></li>
                 * <li>3: MFI (Master file identification segment) <b> </b></li>
                 * <li>4: ERR (Error segment) <b>optional </b></li>
                 * <li>5: MFA (Master file acknowledgement segment) <b>optional repeating</b></li>
                 * <li>6: MFI (Master file identification segment) <b> </b></li>
                 * <li>7: MFK_M01_MF (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class MFK_M01 extends AbstractMessage  {

    /**
     * Creates a new MFK_M01 message with DefaultModelClassFactory. 
     */ 
    public MFK_M01() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new MFK_M01 message with custom ModelClassFactory.
     */
    public MFK_M01(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(MSA.class, true, false);
                          this.add(MFI.class, true, false);
                          this.add(ERR.class, false, false);
                          this.add(MFA.class, false, true);
                          this.add(MFI.class, true, false);
                          this.add(MFK_M01_MF.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating MFK_M01 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3"
     */
    public String getVersion() {
       return "2.3";
    }



    /**
     * Returns
     * MSH (Message header segment) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * MSA (Message acknowledgement segment) - creates it if necessary
     */
    public MSA getMSA() { 
       MSA ret = null;
       try {
          ret = (MSA)this.get("MSA");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * MFI (Master file identification segment) - creates it if necessary
     */
    public MFI getMFI() { 
       MFI ret = null;
       try {
          ret = (MFI)this.get("MFI");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * ERR (Error segment) - creates it if necessary
     */
    public ERR getERR() { 
       ERR ret = null;
       try {
          ret = (ERR)this.get("ERR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * MFA (Master file acknowledgement segment) - creates it if necessary
     */
    public MFA getMFA() { 
       MFA ret = null;
       try {
          ret = (MFA)this.get("MFA");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * MFA (Master file acknowledgement segment) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public MFA getMFA(int rep) { 
       MFA ret = null;
       try {
          ret = (MFA)this.get("MFA", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of MFA 
     */ 
    public int getMFAReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("MFA").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of MFA (Master file acknowledgement segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertMFA(MFA structure, int rep) throws HL7Exception { 
       super.insertRepetition( "MFA", structure, rep);
    }


    /**
     * Inserts a specific repetition of MFA (Master file acknowledgement segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public MFA insertMFA(int rep) throws HL7Exception { 
       return (MFA)super.insertRepetition("MFA", rep);
    }


    /**
     * Removes a specific repetition of MFA (Master file acknowledgement segment)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public MFA removeMFA(int rep) throws HL7Exception { 
       return (MFA)super.removeRepetition("MFA", rep);
    }



    /**
     * Returns
     * MFI2 (Master file identification segment) - creates it if necessary
     */
    public MFI getMFI2() { 
       MFI ret = null;
       try {
          ret = (MFI)this.get("MFI2");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * MF (a Group object) - creates it if necessary
     */
    public MFK_M01_MF getMF() { 
       MFK_M01_MF ret = null;
       try {
          ret = (MFK_M01_MF)this.get("MF");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * MF (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public MFK_M01_MF getMF(int rep) { 
       MFK_M01_MF ret = null;
       try {
          ret = (MFK_M01_MF)this.get("MF", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of MF 
     */ 
    public int getMFReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("MF").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of MF (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertMF(MFK_M01_MF structure, int rep) throws HL7Exception { 
       super.insertRepetition( "MF", structure, rep);
    }


    /**
     * Inserts a specific repetition of MF (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public MFK_M01_MF insertMF(int rep) throws HL7Exception { 
       return (MFK_M01_MF)super.insertRepetition("MF", rep);
    }


    /**
     * Removes a specific repetition of MF (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public MFK_M01_MF removeMF(int rep) throws HL7Exception { 
       return (MFK_M01_MF)super.removeRepetition("MF", rep);
    }



}

