/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.model.v23.group.*;
import ca.uhn.hl7v2.model.v23.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a PPG_PCJ message structure (see chapter ?). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (Message header segment) <b> </b></li>
                 * <li>2: PID (Patient Identification) <b> </b></li>
                 * <li>3: PPG_PCJ_PATIENT_VISIT (a Group object) <b>optional </b></li>
                 * <li>4: PPG_PCJ_PATHWAY (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class PPG_PCJ extends AbstractMessage  {

    /**
     * Creates a new PPG_PCJ message with DefaultModelClassFactory. 
     */ 
    public PPG_PCJ() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new PPG_PCJ message with custom ModelClassFactory.
     */
    public PPG_PCJ(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(PID.class, true, false);
                          this.add(PPG_PCJ_PATIENT_VISIT.class, false, false);
                          this.add(PPG_PCJ_PATHWAY.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PPG_PCJ - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3"
     */
    public String getVersion() {
       return "2.3";
    }



    /**
     * Returns
     * MSH (Message header segment) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * PID (Patient Identification) - creates it if necessary
     */
    public PID getPID() { 
       PID ret = null;
       try {
          ret = (PID)this.get("PID");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * PATIENT_VISIT (a Group object) - creates it if necessary
     */
    public PPG_PCJ_PATIENT_VISIT getPATIENT_VISIT() { 
       PPG_PCJ_PATIENT_VISIT ret = null;
       try {
          ret = (PPG_PCJ_PATIENT_VISIT)this.get("PATIENT_VISIT");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * PATHWAY (a Group object) - creates it if necessary
     */
    public PPG_PCJ_PATHWAY getPATHWAY() { 
       PPG_PCJ_PATHWAY ret = null;
       try {
          ret = (PPG_PCJ_PATHWAY)this.get("PATHWAY");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * PATHWAY (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public PPG_PCJ_PATHWAY getPATHWAY(int rep) { 
       PPG_PCJ_PATHWAY ret = null;
       try {
          ret = (PPG_PCJ_PATHWAY)this.get("PATHWAY", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of PATHWAY 
     */ 
    public int getPATHWAYReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("PATHWAY").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of PATHWAY (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertPATHWAY(PPG_PCJ_PATHWAY structure, int rep) throws HL7Exception { 
       super.insertRepetition( "PATHWAY", structure, rep);
    }


    /**
     * Inserts a specific repetition of PATHWAY (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public PPG_PCJ_PATHWAY insertPATHWAY(int rep) throws HL7Exception { 
       return (PPG_PCJ_PATHWAY)super.insertRepetition("PATHWAY", rep);
    }


    /**
     * Removes a specific repetition of PATHWAY (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public PPG_PCJ_PATHWAY removePATHWAY(int rep) throws HL7Exception { 
       return (PPG_PCJ_PATHWAY)super.removeRepetition("PATHWAY", rep);
    }



}

