/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.model.v23.group.*;
import ca.uhn.hl7v2.model.v23.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a PPR_PC2 message structure (see chapter ?). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (Message header segment) <b> </b></li>
                 * <li>2: PID (Patient Identification) <b> </b></li>
                 * <li>3: PPR_PC2_PATIENT_VISIT (a Group object) <b>optional </b></li>
                 * <li>4: PPR_PC2_PROBLEM (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class PPR_PC2 extends AbstractMessage  {

    /**
     * Creates a new PPR_PC2 message with DefaultModelClassFactory. 
     */ 
    public PPR_PC2() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new PPR_PC2 message with custom ModelClassFactory.
     */
    public PPR_PC2(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(PID.class, true, false);
                          this.add(PPR_PC2_PATIENT_VISIT.class, false, false);
                          this.add(PPR_PC2_PROBLEM.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PPR_PC2 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3"
     */
    public String getVersion() {
       return "2.3";
    }



    /**
     * Returns
     * MSH (Message header segment) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * PID (Patient Identification) - creates it if necessary
     */
    public PID getPID() { 
       PID ret = null;
       try {
          ret = (PID)this.get("PID");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * PATIENT_VISIT (a Group object) - creates it if necessary
     */
    public PPR_PC2_PATIENT_VISIT getPATIENT_VISIT() { 
       PPR_PC2_PATIENT_VISIT ret = null;
       try {
          ret = (PPR_PC2_PATIENT_VISIT)this.get("PATIENT_VISIT");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * PROBLEM (a Group object) - creates it if necessary
     */
    public PPR_PC2_PROBLEM getPROBLEM() { 
       PPR_PC2_PROBLEM ret = null;
       try {
          ret = (PPR_PC2_PROBLEM)this.get("PROBLEM");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * PROBLEM (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public PPR_PC2_PROBLEM getPROBLEM(int rep) { 
       PPR_PC2_PROBLEM ret = null;
       try {
          ret = (PPR_PC2_PROBLEM)this.get("PROBLEM", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of PROBLEM 
     */ 
    public int getPROBLEMReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("PROBLEM").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of PROBLEM (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertPROBLEM(PPR_PC2_PROBLEM structure, int rep) throws HL7Exception { 
       super.insertRepetition( "PROBLEM", structure, rep);
    }


    /**
     * Inserts a specific repetition of PROBLEM (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public PPR_PC2_PROBLEM insertPROBLEM(int rep) throws HL7Exception { 
       return (PPR_PC2_PROBLEM)super.insertRepetition("PROBLEM", rep);
    }


    /**
     * Removes a specific repetition of PROBLEM (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public PPR_PC2_PROBLEM removePROBLEM(int rep) throws HL7Exception { 
       return (PPR_PC2_PROBLEM)super.removeRepetition("PROBLEM", rep);
    }



}

