/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v23.segment;

// import ca.uhn.hl7v2.model.v23.group.*;
import ca.uhn.hl7v2.model.v23.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 ERR message segment (Error segment). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>ERR-1: Error Code and Location (CM_ELD) <b> repeating</b>
 * </ul>
 */
public class ERR extends AbstractSegment {

    /** 
     * Creates a new ERR segment
     */
    public ERR(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(CM_ELD.class, true, 0, 80, new Object[]{ getMessage(), new Integer(60) }, "Error Code and Location");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ERR - this is probably a bug in the source code generator.", e);
       }
    }


    /**
     * Returns all repetitions of Error Code and Location (ERR-1).
     */
    public CM_ELD[] getErrorCodeAndLocation() {
        CM_ELD[] ret = null;
        try {
            Type[] t = this.getField(1);  
            ret = new CM_ELD[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CM_ELD)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Error Code and Location (ERR-1).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getErrorCodeAndLocationReps() {
        CM_ELD[] ret = null;
        try {
            Type[] t = this.getField(1);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * ERR-1: "Error Code and Location" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CM_ELD getErrorCodeAndLocation(int rep) { 
        CM_ELD ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (CM_ELD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * ERR-1: "Error Code and Location" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CM_ELD getErr1_ErrorCodeAndLocation(int rep) { 
        CM_ELD ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (CM_ELD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Error Code and Location (ERR-1).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getErr1_ErrorCodeAndLocationReps() {
        CM_ELD[] ret = null;
        try {
            Type[] t = this.getField(1);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * ERR-1: "Error Code and Location" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CM_ELD insertErrorCodeAndLocation(int rep) throws HL7Exception { 
        return (CM_ELD) super.insertRepetition(1, rep);
    }



    /**
     * Inserts a repetition of
     * ERR-1: "Error Code and Location" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CM_ELD insertErr1_ErrorCodeAndLocation(int rep) throws HL7Exception { 
        return (CM_ELD) super.insertRepetition(1, rep);
    }


    /**
     * Removes a repetition of
     * ERR-1: "Error Code and Location" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CM_ELD removeErrorCodeAndLocation(int rep) throws HL7Exception { 
        return (CM_ELD) super.removeRepetition(1, rep);
    }


    /**
     * Removes a repetition of
     * ERR-1: "Error Code and Location" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CM_ELD removeErr1_ErrorCodeAndLocation(int rep) throws HL7Exception { 
        return (CM_ELD) super.removeRepetition(1, rep);
    }






    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new CM_ELD(getMessage());
          default: return null;
       }
   }


}

