/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v23.segment;

// import ca.uhn.hl7v2.model.v23.group.*;
import ca.uhn.hl7v2.model.v23.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 MRG message segment (Merge patient information). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>MRG-1: Prior Patient ID - Internal (CX) <b> repeating</b>
     * <li>MRG-2: Prior Alternate Patient ID (CX) <b>optional repeating</b>
     * <li>MRG-3: Prior Patient Account Number (CX) <b>optional </b>
     * <li>MRG-4: Prior Patient ID - External (CX) <b>optional </b>
     * <li>MRG-5: Prior Visit Number (CX) <b>optional </b>
     * <li>MRG-6: Prior Alternate Visit ID (CX) <b>optional </b>
     * <li>MRG-7: Prior Patient Name (CX) <b>optional </b>
 * </ul>
 */
public class MRG extends AbstractSegment {

    /** 
     * Creates a new MRG segment
     */
    public MRG(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(CX.class, true, 0, 20, new Object[]{ getMessage(), new Integer(0) }, "Prior Patient ID - Internal");
                                  this.add(CX.class, false, 0, 16, new Object[]{ getMessage(), new Integer(0) }, "Prior Alternate Patient ID");
                                  this.add(CX.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Prior Patient Account Number");
                                  this.add(CX.class, false, 1, 16, new Object[]{ getMessage(), new Integer(0) }, "Prior Patient ID - External");
                                  this.add(CX.class, false, 1, 0, new Object[]{ getMessage(), new Integer(0) }, "Prior Visit Number");
                                  this.add(CX.class, false, 1, 0, new Object[]{ getMessage(), new Integer(0) }, "Prior Alternate Visit ID");
                                  this.add(CX.class, false, 1, 0, new Object[]{ getMessage(), new Integer(0) }, "Prior Patient Name");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating MRG - this is probably a bug in the source code generator.", e);
       }
    }


    /**
     * Returns all repetitions of Prior Patient ID - Internal (MRG-1).
     */
    public CX[] getPriorPatientIDInternal() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(1);  
            ret = new CX[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CX)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Prior Patient ID - Internal (MRG-1).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getPriorPatientIDInternalReps() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(1);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * MRG-1: "Prior Patient ID - Internal" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CX getPriorPatientIDInternal(int rep) { 
        CX ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * MRG-1: "Prior Patient ID - Internal" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CX getMrg1_PriorPatientIDInternal(int rep) { 
        CX ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Prior Patient ID - Internal (MRG-1).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getMrg1_PriorPatientIDInternalReps() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(1);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * MRG-1: "Prior Patient ID - Internal" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX insertPriorPatientIDInternal(int rep) throws HL7Exception { 
        return (CX) super.insertRepetition(1, rep);
    }



    /**
     * Inserts a repetition of
     * MRG-1: "Prior Patient ID - Internal" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX insertMrg1_PriorPatientIDInternal(int rep) throws HL7Exception { 
        return (CX) super.insertRepetition(1, rep);
    }


    /**
     * Removes a repetition of
     * MRG-1: "Prior Patient ID - Internal" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX removePriorPatientIDInternal(int rep) throws HL7Exception { 
        return (CX) super.removeRepetition(1, rep);
    }


    /**
     * Removes a repetition of
     * MRG-1: "Prior Patient ID - Internal" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX removeMrg1_PriorPatientIDInternal(int rep) throws HL7Exception { 
        return (CX) super.removeRepetition(1, rep);
    }



    /**
     * Returns all repetitions of Prior Alternate Patient ID (MRG-2).
     */
    public CX[] getPriorAlternatePatientID() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(2);  
            ret = new CX[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CX)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Prior Alternate Patient ID (MRG-2).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getPriorAlternatePatientIDReps() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(2);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * MRG-2: "Prior Alternate Patient ID" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CX getPriorAlternatePatientID(int rep) { 
        CX ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * MRG-2: "Prior Alternate Patient ID" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CX getMrg2_PriorAlternatePatientID(int rep) { 
        CX ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Prior Alternate Patient ID (MRG-2).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getMrg2_PriorAlternatePatientIDReps() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(2);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * MRG-2: "Prior Alternate Patient ID" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX insertPriorAlternatePatientID(int rep) throws HL7Exception { 
        return (CX) super.insertRepetition(2, rep);
    }



    /**
     * Inserts a repetition of
     * MRG-2: "Prior Alternate Patient ID" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX insertMrg2_PriorAlternatePatientID(int rep) throws HL7Exception { 
        return (CX) super.insertRepetition(2, rep);
    }


    /**
     * Removes a repetition of
     * MRG-2: "Prior Alternate Patient ID" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX removePriorAlternatePatientID(int rep) throws HL7Exception { 
        return (CX) super.removeRepetition(2, rep);
    }


    /**
     * Removes a repetition of
     * MRG-2: "Prior Alternate Patient ID" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX removeMrg2_PriorAlternatePatientID(int rep) throws HL7Exception { 
        return (CX) super.removeRepetition(2, rep);
    }




    /**
     * Returns
     * MRG-3: "Prior Patient Account Number" - creates it if necessary
     */
    public CX getPriorPatientAccountNumber() { 
        CX ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MRG-3: "Prior Patient Account Number" - creates it if necessary
     */
    public CX getMrg3_PriorPatientAccountNumber() { 
        CX ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MRG-4: "Prior Patient ID - External" - creates it if necessary
     */
    public CX getPriorPatientIDExternal() { 
        CX ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MRG-4: "Prior Patient ID - External" - creates it if necessary
     */
    public CX getMrg4_PriorPatientIDExternal() { 
        CX ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MRG-5: "Prior Visit Number" - creates it if necessary
     */
    public CX getPriorVisitNumber() { 
        CX ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MRG-5: "Prior Visit Number" - creates it if necessary
     */
    public CX getMrg5_PriorVisitNumber() { 
        CX ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MRG-6: "Prior Alternate Visit ID" - creates it if necessary
     */
    public CX getPriorAlternateVisitID() { 
        CX ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MRG-6: "Prior Alternate Visit ID" - creates it if necessary
     */
    public CX getMrg6_PriorAlternateVisitID() { 
        CX ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MRG-7: "Prior Patient Name" - creates it if necessary
     */
    public CX getPriorPatientName() { 
        CX ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MRG-7: "Prior Patient Name" - creates it if necessary
     */
    public CX getMrg7_PriorPatientName() { 
        CX ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new CX(getMessage());
          case 1: return new CX(getMessage());
          case 2: return new CX(getMessage());
          case 3: return new CX(getMessage());
          case 4: return new CX(getMessage());
          case 5: return new CX(getMessage());
          case 6: return new CX(getMessage());
          default: return null;
       }
   }


}

