/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.PPR_PC3_PATIENT_VISIT;
import ca.uhn.hl7v2.model.v23.group.PPR_PC3_PROBLEM;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.model.v23.segment.PID;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class PPR_PC3
extends AbstractMessage {
    public PPR_PC3() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public PPR_PC3(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(PID.class, true, false);
            this.add(PPR_PC3_PATIENT_VISIT.class, false, false);
            this.add(PPR_PC3_PROBLEM.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating PPR_PC3 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PID getPID() {
        PID ret = null;
        try {
            ret = (PID)this.get("PID");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PPR_PC3_PATIENT_VISIT getPATIENT_VISIT() {
        PPR_PC3_PATIENT_VISIT ret = null;
        try {
            ret = (PPR_PC3_PATIENT_VISIT)this.get("PATIENT_VISIT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PPR_PC3_PROBLEM getPROBLEM() {
        PPR_PC3_PROBLEM ret = null;
        try {
            ret = (PPR_PC3_PROBLEM)this.get("PROBLEM");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PPR_PC3_PROBLEM getPROBLEM(int rep) {
        PPR_PC3_PROBLEM ret = null;
        try {
            ret = (PPR_PC3_PROBLEM)this.get("PROBLEM", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPROBLEMReps() {
        int reps = -1;
        try {
            reps = this.getAll("PROBLEM").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPROBLEM(PPR_PC3_PROBLEM structure, int rep) throws HL7Exception {
        super.insertRepetition("PROBLEM", (Structure)structure, rep);
    }

    public PPR_PC3_PROBLEM insertPROBLEM(int rep) throws HL7Exception {
        return (PPR_PC3_PROBLEM)super.insertRepetition("PROBLEM", rep);
    }

    public PPR_PC3_PROBLEM removePROBLEM(int rep) throws HL7Exception {
        return (PPR_PC3_PROBLEM)super.removeRepetition("PROBLEM", rep);
    }
}

