/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.CSU_C09_RX_ADMIN;
import ca.uhn.hl7v2.model.v23.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSU_C09_STUDY_PHARM
extends AbstractGroup {
    public CSU_C09_STUDY_PHARM(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, false, false);
            this.add(CSU_C09_RX_ADMIN.class, true, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating CSU_C09_STUDY_PHARM - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CSU_C09_RX_ADMIN getRX_ADMIN() {
        CSU_C09_RX_ADMIN ret = null;
        try {
            ret = (CSU_C09_RX_ADMIN)this.get("RX_ADMIN");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CSU_C09_RX_ADMIN getRX_ADMIN(int rep) {
        CSU_C09_RX_ADMIN ret = null;
        try {
            ret = (CSU_C09_RX_ADMIN)this.get("RX_ADMIN", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getRX_ADMINReps() {
        int reps = -1;
        try {
            reps = this.getAll("RX_ADMIN").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<CSU_C09_RX_ADMIN> getRX_ADMINAll() throws HL7Exception {
        return this.getAllAsList("RX_ADMIN", CSU_C09_RX_ADMIN.class);
    }

    public void insertRX_ADMIN(CSU_C09_RX_ADMIN structure, int rep) throws HL7Exception {
        super.insertRepetition("RX_ADMIN", (Structure)structure, rep);
    }

    public CSU_C09_RX_ADMIN insertRX_ADMIN(int rep) throws HL7Exception {
        return (CSU_C09_RX_ADMIN)super.insertRepetition("RX_ADMIN", rep);
    }

    public CSU_C09_RX_ADMIN removeRX_ADMIN(int rep) throws HL7Exception {
        return (CSU_C09_RX_ADMIN)super.removeRepetition("RX_ADMIN", rep);
    }
}

