/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.CSU_C12_STUDY_SCHEDULE;
import ca.uhn.hl7v2.model.v23.segment.CSP;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSU_C12_STUDY_PHASE
extends AbstractGroup {
    public CSU_C12_STUDY_PHASE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CSP.class, false, false);
            this.add(CSU_C12_STUDY_SCHEDULE.class, true, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating CSU_C12_STUDY_PHASE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public CSP getCSP() {
        CSP ret = null;
        try {
            ret = (CSP)this.get("CSP");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CSU_C12_STUDY_SCHEDULE getSTUDY_SCHEDULE() {
        CSU_C12_STUDY_SCHEDULE ret = null;
        try {
            ret = (CSU_C12_STUDY_SCHEDULE)this.get("STUDY_SCHEDULE");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CSU_C12_STUDY_SCHEDULE getSTUDY_SCHEDULE(int rep) {
        CSU_C12_STUDY_SCHEDULE ret = null;
        try {
            ret = (CSU_C12_STUDY_SCHEDULE)this.get("STUDY_SCHEDULE", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getSTUDY_SCHEDULEReps() {
        int reps = -1;
        try {
            reps = this.getAll("STUDY_SCHEDULE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<CSU_C12_STUDY_SCHEDULE> getSTUDY_SCHEDULEAll() throws HL7Exception {
        return this.getAllAsList("STUDY_SCHEDULE", CSU_C12_STUDY_SCHEDULE.class);
    }

    public void insertSTUDY_SCHEDULE(CSU_C12_STUDY_SCHEDULE structure, int rep) throws HL7Exception {
        super.insertRepetition("STUDY_SCHEDULE", (Structure)structure, rep);
    }

    public CSU_C12_STUDY_SCHEDULE insertSTUDY_SCHEDULE(int rep) throws HL7Exception {
        return (CSU_C12_STUDY_SCHEDULE)super.insertRepetition("STUDY_SCHEDULE", rep);
    }

    public CSU_C12_STUDY_SCHEDULE removeSTUDY_SCHEDULE(int rep) throws HL7Exception {
        return (CSU_C12_STUDY_SCHEDULE)super.removeRepetition("STUDY_SCHEDULE", rep);
    }
}

