/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.PPT_PCL_GOAL_OBSERVATION;
import ca.uhn.hl7v2.model.v23.group.PPT_PCL_GOAL_ROLE;
import ca.uhn.hl7v2.model.v23.group.PPT_PCL_ORDER;
import ca.uhn.hl7v2.model.v23.group.PPT_PCL_PROBLEM;
import ca.uhn.hl7v2.model.v23.segment.GOL;
import ca.uhn.hl7v2.model.v23.segment.NTE;
import ca.uhn.hl7v2.model.v23.segment.VAR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PPT_PCL_GOAL
extends AbstractGroup {
    public PPT_PCL_GOAL(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(GOL.class, true, false);
            this.add(NTE.class, false, true);
            this.add(VAR.class, false, true);
            this.add(PPT_PCL_GOAL_ROLE.class, false, true);
            this.add(PPT_PCL_GOAL_OBSERVATION.class, false, true);
            this.add(PPT_PCL_PROBLEM.class, false, true);
            this.add(PPT_PCL_ORDER.class, false, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating PPT_PCL_GOAL - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public GOL getGOL() {
        GOL retVal = (GOL)this.getTyped("GOL", GOL.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public VAR getVAR() {
        VAR retVal = (VAR)this.getTyped("VAR", VAR.class);
        return retVal;
    }

    public VAR getVAR(int rep) {
        VAR retVal = (VAR)this.getTyped("VAR", rep, VAR.class);
        return retVal;
    }

    public int getVARReps() {
        return this.getReps("VAR");
    }

    public List<VAR> getVARAll() throws HL7Exception {
        return this.getAllAsList("VAR", VAR.class);
    }

    public void insertVAR(VAR structure, int rep) throws HL7Exception {
        super.insertRepetition("VAR", (Structure)structure, rep);
    }

    public VAR insertVAR(int rep) throws HL7Exception {
        return (VAR)super.insertRepetition("VAR", rep);
    }

    public VAR removeVAR(int rep) throws HL7Exception {
        return (VAR)super.removeRepetition("VAR", rep);
    }

    public PPT_PCL_GOAL_ROLE getGOAL_ROLE() {
        PPT_PCL_GOAL_ROLE retVal = (PPT_PCL_GOAL_ROLE)this.getTyped("GOAL_ROLE", PPT_PCL_GOAL_ROLE.class);
        return retVal;
    }

    public PPT_PCL_GOAL_ROLE getGOAL_ROLE(int rep) {
        PPT_PCL_GOAL_ROLE retVal = (PPT_PCL_GOAL_ROLE)this.getTyped("GOAL_ROLE", rep, PPT_PCL_GOAL_ROLE.class);
        return retVal;
    }

    public int getGOAL_ROLEReps() {
        return this.getReps("GOAL_ROLE");
    }

    public List<PPT_PCL_GOAL_ROLE> getGOAL_ROLEAll() throws HL7Exception {
        return this.getAllAsList("GOAL_ROLE", PPT_PCL_GOAL_ROLE.class);
    }

    public void insertGOAL_ROLE(PPT_PCL_GOAL_ROLE structure, int rep) throws HL7Exception {
        super.insertRepetition("GOAL_ROLE", (Structure)structure, rep);
    }

    public PPT_PCL_GOAL_ROLE insertGOAL_ROLE(int rep) throws HL7Exception {
        return (PPT_PCL_GOAL_ROLE)super.insertRepetition("GOAL_ROLE", rep);
    }

    public PPT_PCL_GOAL_ROLE removeGOAL_ROLE(int rep) throws HL7Exception {
        return (PPT_PCL_GOAL_ROLE)super.removeRepetition("GOAL_ROLE", rep);
    }

    public PPT_PCL_GOAL_OBSERVATION getGOAL_OBSERVATION() {
        PPT_PCL_GOAL_OBSERVATION retVal = (PPT_PCL_GOAL_OBSERVATION)this.getTyped("GOAL_OBSERVATION", PPT_PCL_GOAL_OBSERVATION.class);
        return retVal;
    }

    public PPT_PCL_GOAL_OBSERVATION getGOAL_OBSERVATION(int rep) {
        PPT_PCL_GOAL_OBSERVATION retVal = (PPT_PCL_GOAL_OBSERVATION)this.getTyped("GOAL_OBSERVATION", rep, PPT_PCL_GOAL_OBSERVATION.class);
        return retVal;
    }

    public int getGOAL_OBSERVATIONReps() {
        return this.getReps("GOAL_OBSERVATION");
    }

    public List<PPT_PCL_GOAL_OBSERVATION> getGOAL_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("GOAL_OBSERVATION", PPT_PCL_GOAL_OBSERVATION.class);
    }

    public void insertGOAL_OBSERVATION(PPT_PCL_GOAL_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("GOAL_OBSERVATION", (Structure)structure, rep);
    }

    public PPT_PCL_GOAL_OBSERVATION insertGOAL_OBSERVATION(int rep) throws HL7Exception {
        return (PPT_PCL_GOAL_OBSERVATION)super.insertRepetition("GOAL_OBSERVATION", rep);
    }

    public PPT_PCL_GOAL_OBSERVATION removeGOAL_OBSERVATION(int rep) throws HL7Exception {
        return (PPT_PCL_GOAL_OBSERVATION)super.removeRepetition("GOAL_OBSERVATION", rep);
    }

    public PPT_PCL_PROBLEM getPROBLEM() {
        PPT_PCL_PROBLEM retVal = (PPT_PCL_PROBLEM)this.getTyped("PROBLEM", PPT_PCL_PROBLEM.class);
        return retVal;
    }

    public PPT_PCL_PROBLEM getPROBLEM(int rep) {
        PPT_PCL_PROBLEM retVal = (PPT_PCL_PROBLEM)this.getTyped("PROBLEM", rep, PPT_PCL_PROBLEM.class);
        return retVal;
    }

    public int getPROBLEMReps() {
        return this.getReps("PROBLEM");
    }

    public List<PPT_PCL_PROBLEM> getPROBLEMAll() throws HL7Exception {
        return this.getAllAsList("PROBLEM", PPT_PCL_PROBLEM.class);
    }

    public void insertPROBLEM(PPT_PCL_PROBLEM structure, int rep) throws HL7Exception {
        super.insertRepetition("PROBLEM", (Structure)structure, rep);
    }

    public PPT_PCL_PROBLEM insertPROBLEM(int rep) throws HL7Exception {
        return (PPT_PCL_PROBLEM)super.insertRepetition("PROBLEM", rep);
    }

    public PPT_PCL_PROBLEM removePROBLEM(int rep) throws HL7Exception {
        return (PPT_PCL_PROBLEM)super.removeRepetition("PROBLEM", rep);
    }

    public PPT_PCL_ORDER getORDER() {
        PPT_PCL_ORDER retVal = (PPT_PCL_ORDER)this.getTyped("ORDER", PPT_PCL_ORDER.class);
        return retVal;
    }

    public PPT_PCL_ORDER getORDER(int rep) {
        PPT_PCL_ORDER retVal = (PPT_PCL_ORDER)this.getTyped("ORDER", rep, PPT_PCL_ORDER.class);
        return retVal;
    }

    public int getORDERReps() {
        return this.getReps("ORDER");
    }

    public List<PPT_PCL_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", PPT_PCL_ORDER.class);
    }

    public void insertORDER(PPT_PCL_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", (Structure)structure, rep);
    }

    public PPT_PCL_ORDER insertORDER(int rep) throws HL7Exception {
        return (PPT_PCL_ORDER)super.insertRepetition("ORDER", rep);
    }

    public PPT_PCL_ORDER removeORDER(int rep) throws HL7Exception {
        return (PPT_PCL_ORDER)super.removeRepetition("ORDER", rep);
    }
}

