/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.RDS_O01_ENCODING;
import ca.uhn.hl7v2.model.v23.group.RDS_O01_OBSERVATION;
import ca.uhn.hl7v2.model.v23.group.RDS_O01_ORDER_DETAIL;
import ca.uhn.hl7v2.model.v23.segment.ORC;
import ca.uhn.hl7v2.model.v23.segment.RXC;
import ca.uhn.hl7v2.model.v23.segment.RXD;
import ca.uhn.hl7v2.model.v23.segment.RXR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDS_O01_ORDER
extends AbstractGroup {
    public RDS_O01_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(RDS_O01_ORDER_DETAIL.class, false, false, false);
            this.add(RDS_O01_ENCODING.class, false, false, false);
            this.add(RXD.class, true, false, false);
            this.add(RXR.class, true, true, false);
            this.add(RXC.class, false, true, false);
            this.add(RDS_O01_OBSERVATION.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RDS_O01_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public ORC getORC() {
        ORC retVal = (ORC)this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public RDS_O01_ORDER_DETAIL getORDER_DETAIL() {
        RDS_O01_ORDER_DETAIL retVal = (RDS_O01_ORDER_DETAIL)this.getTyped("ORDER_DETAIL", RDS_O01_ORDER_DETAIL.class);
        return retVal;
    }

    public RDS_O01_ENCODING getENCODING() {
        RDS_O01_ENCODING retVal = (RDS_O01_ENCODING)this.getTyped("ENCODING", RDS_O01_ENCODING.class);
        return retVal;
    }

    public RXD getRXD() {
        RXD retVal = (RXD)this.getTyped("RXD", RXD.class);
        return retVal;
    }

    public RXR getRXR() {
        RXR retVal = (RXR)this.getTyped("RXR", RXR.class);
        return retVal;
    }

    public RXR getRXR(int rep) {
        RXR retVal = (RXR)this.getTyped("RXR", rep, RXR.class);
        return retVal;
    }

    public int getRXRReps() {
        return this.getReps("RXR");
    }

    public List<RXR> getRXRAll() throws HL7Exception {
        return this.getAllAsList("RXR", RXR.class);
    }

    public void insertRXR(RXR structure, int rep) throws HL7Exception {
        super.insertRepetition("RXR", (Structure)structure, rep);
    }

    public RXR insertRXR(int rep) throws HL7Exception {
        return (RXR)super.insertRepetition("RXR", rep);
    }

    public RXR removeRXR(int rep) throws HL7Exception {
        return (RXR)super.removeRepetition("RXR", rep);
    }

    public RXC getRXC() {
        RXC retVal = (RXC)this.getTyped("RXC", RXC.class);
        return retVal;
    }

    public RXC getRXC(int rep) {
        RXC retVal = (RXC)this.getTyped("RXC", rep, RXC.class);
        return retVal;
    }

    public int getRXCReps() {
        return this.getReps("RXC");
    }

    public List<RXC> getRXCAll() throws HL7Exception {
        return this.getAllAsList("RXC", RXC.class);
    }

    public void insertRXC(RXC structure, int rep) throws HL7Exception {
        super.insertRepetition("RXC", (Structure)structure, rep);
    }

    public RXC insertRXC(int rep) throws HL7Exception {
        return (RXC)super.insertRepetition("RXC", rep);
    }

    public RXC removeRXC(int rep) throws HL7Exception {
        return (RXC)super.removeRepetition("RXC", rep);
    }

    public RDS_O01_OBSERVATION getOBSERVATION() {
        RDS_O01_OBSERVATION retVal = (RDS_O01_OBSERVATION)this.getTyped("OBSERVATION", RDS_O01_OBSERVATION.class);
        return retVal;
    }

    public RDS_O01_OBSERVATION getOBSERVATION(int rep) {
        RDS_O01_OBSERVATION retVal = (RDS_O01_OBSERVATION)this.getTyped("OBSERVATION", rep, RDS_O01_OBSERVATION.class);
        return retVal;
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<RDS_O01_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", RDS_O01_OBSERVATION.class);
    }

    public void insertOBSERVATION(RDS_O01_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", (Structure)structure, rep);
    }

    public RDS_O01_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (RDS_O01_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public RDS_O01_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (RDS_O01_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }
}

