/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.CRM_C02_PATIENT;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class CRM_C02
extends AbstractMessage {
    public CRM_C02() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public CRM_C02(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(CRM_C02_PATIENT.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CRM_C02 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public CRM_C02_PATIENT getPATIENT() {
        return (CRM_C02_PATIENT)this.getTyped("PATIENT", CRM_C02_PATIENT.class);
    }

    public CRM_C02_PATIENT getPATIENT(int rep) {
        return (CRM_C02_PATIENT)this.getTyped("PATIENT", rep, CRM_C02_PATIENT.class);
    }

    public int getPATIENTReps() {
        return this.getReps("PATIENT");
    }

    public List<CRM_C02_PATIENT> getPATIENTAll() throws HL7Exception {
        return this.getAllAsList("PATIENT", CRM_C02_PATIENT.class);
    }

    public void insertPATIENT(CRM_C02_PATIENT structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT", (Structure)structure, rep);
    }

    public CRM_C02_PATIENT insertPATIENT(int rep) throws HL7Exception {
        return (CRM_C02_PATIENT)super.insertRepetition("PATIENT", rep);
    }

    public CRM_C02_PATIENT removePATIENT(int rep) throws HL7Exception {
        return (CRM_C02_PATIENT)super.removeRepetition("PATIENT", rep);
    }
}

