/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v231.datatype.CE;
import ca.uhn.hl7v2.model.v231.datatype.DT;
import ca.uhn.hl7v2.model.v231.datatype.ID;
import ca.uhn.hl7v2.model.v231.datatype.IS;
import ca.uhn.hl7v2.model.v231.datatype.PIP;
import ca.uhn.hl7v2.model.v231.datatype.PLN;
import ca.uhn.hl7v2.model.v231.datatype.SPD;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class PRA
extends AbstractSegment {
    public PRA(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, true, 1, 60, new Object[]{this.getMessage(), new Integer(0)}, "Primary Key Value - PRA");
            this.add(CE.class, false, 0, 60, new Object[]{this.getMessage(), new Integer(358)}, "Practitioner Group");
            this.add(IS.class, false, 0, 3, new Object[]{this.getMessage()}, "Practitioner Category");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage()}, "Provider Billing");
            this.add(SPD.class, false, 0, 100, new Object[]{this.getMessage(), new Integer(337)}, "Specialty");
            this.add(PLN.class, false, 0, 100, new Object[]{this.getMessage(), new Integer(338)}, "Practitioner ID Numbers");
            this.add(PIP.class, false, 0, 200, new Object[]{this.getMessage(), new Integer(0)}, "Privileges");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage(), new Integer(0)}, "Date Entered Practice");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating PRA - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CE getPrimaryKeyValuePRA() {
        CE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getPra1_PrimaryKeyValuePRA() {
        CE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE[] getPractitionerGroup() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(2);
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CE)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getPractitionerGroup(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getPra2_PractitionerGroup(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE insertPractitionerGroup(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(2, rep);
    }

    public CE insertPra2_PractitionerGroup(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(2, rep);
    }

    public CE removePractitionerGroup(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(2, rep);
    }

    public CE removePra2_PractitionerGroup(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(2, rep);
    }

    public IS[] getPractitionerCategory() {
        IS[] ret = null;
        try {
            Type[] t = this.getField(3);
            ret = new IS[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (IS)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPractitionerCategory(int rep) {
        IS ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPra3_PractitionerCategory(int rep) {
        IS ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS insertPractitionerCategory(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(3, rep);
    }

    public IS insertPra3_PractitionerCategory(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(3, rep);
    }

    public IS removePractitionerCategory(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(3, rep);
    }

    public IS removePra3_PractitionerCategory(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(3, rep);
    }

    public ID getProviderBilling() {
        ID ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getPra4_ProviderBilling() {
        ID ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public SPD[] getSpecialty() {
        SPD[] ret = null;
        try {
            Type[] t = this.getField(5);
            ret = new SPD[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (SPD)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public SPD getSpecialty(int rep) {
        SPD ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (SPD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public SPD getPra5_Specialty(int rep) {
        SPD ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (SPD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public SPD insertSpecialty(int rep) throws HL7Exception {
        return (SPD)super.insertRepetition(5, rep);
    }

    public SPD insertPra5_Specialty(int rep) throws HL7Exception {
        return (SPD)super.insertRepetition(5, rep);
    }

    public SPD removeSpecialty(int rep) throws HL7Exception {
        return (SPD)super.removeRepetition(5, rep);
    }

    public SPD removePra5_Specialty(int rep) throws HL7Exception {
        return (SPD)super.removeRepetition(5, rep);
    }

    public PLN[] getPractitionerIDNumbers() {
        PLN[] ret = null;
        try {
            Type[] t = this.getField(6);
            ret = new PLN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (PLN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public PLN getPractitionerIDNumbers(int rep) {
        PLN ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (PLN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public PLN getPra6_PractitionerIDNumbers(int rep) {
        PLN ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (PLN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public PLN insertPractitionerIDNumbers(int rep) throws HL7Exception {
        return (PLN)super.insertRepetition(6, rep);
    }

    public PLN insertPra6_PractitionerIDNumbers(int rep) throws HL7Exception {
        return (PLN)super.insertRepetition(6, rep);
    }

    public PLN removePractitionerIDNumbers(int rep) throws HL7Exception {
        return (PLN)super.removeRepetition(6, rep);
    }

    public PLN removePra6_PractitionerIDNumbers(int rep) throws HL7Exception {
        return (PLN)super.removeRepetition(6, rep);
    }

    public PIP[] getPrivileges() {
        PIP[] ret = null;
        try {
            Type[] t = this.getField(7);
            ret = new PIP[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (PIP)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public PIP getPrivileges(int rep) {
        PIP ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (PIP)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public PIP getPra7_Privileges(int rep) {
        PIP ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (PIP)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public PIP insertPrivileges(int rep) throws HL7Exception {
        return (PIP)super.insertRepetition(7, rep);
    }

    public PIP insertPra7_Privileges(int rep) throws HL7Exception {
        return (PIP)super.insertRepetition(7, rep);
    }

    public PIP removePrivileges(int rep) throws HL7Exception {
        return (PIP)super.removeRepetition(7, rep);
    }

    public PIP removePra7_Privileges(int rep) throws HL7Exception {
        return (PIP)super.removeRepetition(7, rep);
    }

    public DT getDateEnteredPractice() {
        DT ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getPra8_DateEnteredPractice() {
        DT ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new IS(this.getMessage(), new Integer(186));
            }
            case 3: {
                return new ID(this.getMessage(), new Integer(187));
            }
            case 4: {
                return new SPD(this.getMessage());
            }
            case 5: {
                return new PLN(this.getMessage());
            }
            case 6: {
                return new PIP(this.getMessage());
            }
            case 7: {
                return new DT(this.getMessage());
            }
        }
        return null;
    }
}

