/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 CCP (channel calibration parameters) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>channel calibration sensitivity correction factor (NM)
 * <li>channel calibration baseline (NM)
 * <li>channel calibration time skew (NM)
 * </ul>
 */
public class CCP extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new CCP type
     */
    public CCP(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[3];    
        data[0] = new NM(getMessage());
        data[1] = new NM(getMessage());
        data[2] = new NM(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns channel calibration sensitivity correction factor (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getChannelCalibrationSensitivityCorrectionFactor() {
       NM ret = null;
       try {
          ret = (NM)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns channel calibration sensitivity correction factor (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getCcp1_ChannelCalibrationSensitivityCorrectionFactor() {
       NM ret = null;
       try {
          ret = (NM)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns channel calibration baseline (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getChannelCalibrationBaseline() {
       NM ret = null;
       try {
          ret = (NM)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns channel calibration baseline (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getCcp2_ChannelCalibrationBaseline() {
       NM ret = null;
       try {
          ret = (NM)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns channel calibration time skew (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getChannelCalibrationTimeSkew() {
       NM ret = null;
       try {
          ret = (NM)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns channel calibration time skew (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getCcp3_ChannelCalibrationTimeSkew() {
       NM ret = null;
       try {
          ret = (NM)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

