/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 CSU (channel sensitivity/units) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>channel sensitivity (NM)
 * <li>unit of measure identifier (ST)
 * <li>unit of measure description (ST)
 * <li>unit of measure coding system (IS)
 * <li>alternate unit of measure identifier (ST)
 * <li>alternate unit of measure description (ST)
 * <li>alternate unit of measure coding system (IS)
 * </ul>
 */
public class CSU extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new CSU type
     */
    public CSU(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[7];    
        data[0] = new NM(getMessage());
        data[1] = new ST(getMessage());
        data[2] = new ST(getMessage());
        data[3] = new IS(getMessage(), 0);
        data[4] = new ST(getMessage());
        data[5] = new ST(getMessage());
        data[6] = new IS(getMessage(), 0);
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns channel sensitivity (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getChannelSensitivity() {
       NM ret = null;
       try {
          ret = (NM)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns channel sensitivity (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getCsu1_ChannelSensitivity() {
       NM ret = null;
       try {
          ret = (NM)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns unit of measure identifier (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getUnitOfMeasureIdentifier() {
       ST ret = null;
       try {
          ret = (ST)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns unit of measure identifier (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCsu2_UnitOfMeasureIdentifier() {
       ST ret = null;
       try {
          ret = (ST)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns unit of measure description (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getUnitOfMeasureDescription() {
       ST ret = null;
       try {
          ret = (ST)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns unit of measure description (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCsu3_UnitOfMeasureDescription() {
       ST ret = null;
       try {
          ret = (ST)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns unit of measure coding system (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getUnitOfMeasureCodingSystem() {
       IS ret = null;
       try {
          ret = (IS)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns unit of measure coding system (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getCsu4_UnitOfMeasureCodingSystem() {
       IS ret = null;
       try {
          ret = (IS)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns alternate unit of measure identifier (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getAlternateUnitOfMeasureIdentifier() {
       ST ret = null;
       try {
          ret = (ST)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns alternate unit of measure identifier (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCsu5_AlternateUnitOfMeasureIdentifier() {
       ST ret = null;
       try {
          ret = (ST)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns alternate unit of measure description (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getAlternateUnitOfMeasureDescription() {
       ST ret = null;
       try {
          ret = (ST)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns alternate unit of measure description (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCsu6_AlternateUnitOfMeasureDescription() {
       ST ret = null;
       try {
          ret = (ST)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns alternate unit of measure coding system (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getAlternateUnitOfMeasureCodingSystem() {
       IS ret = null;
       try {
          ret = (IS)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns alternate unit of measure coding system (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getCsu7_AlternateUnitOfMeasureCodingSystem() {
       IS ret = null;
       try {
          ret = (IS)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

