/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 CWE (coded with exceptions) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>identifier (ST)
 * <li>text (ST)
 * <li>name of coding system (ST)
 * <li>alternate identifier (ST)
 * <li>alternate text (ST)
 * <li>name of alternate coding system (ST)
 * <li>coding system version ID (ST)
 * <li>alternate coding system version ID (ST)
 * <li>original text (ST)
 * </ul>
 */
public class CWE extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new CWE type
     */
    public CWE(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[9];    
        data[0] = new ST(getMessage());
        data[1] = new ST(getMessage());
        data[2] = new ST(getMessage());
        data[3] = new ST(getMessage());
        data[4] = new ST(getMessage());
        data[5] = new ST(getMessage());
        data[6] = new ST(getMessage());
        data[7] = new ST(getMessage());
        data[8] = new ST(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns identifier (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getIdentifier() {
       ST ret = null;
       try {
          ret = (ST)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns identifier (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCwe1_Identifier() {
       ST ret = null;
       try {
          ret = (ST)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns text (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getText() {
       ST ret = null;
       try {
          ret = (ST)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns text (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCwe2_Text() {
       ST ret = null;
       try {
          ret = (ST)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns name of coding system (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getNameOfCodingSystem() {
       ST ret = null;
       try {
          ret = (ST)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns name of coding system (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCwe3_NameOfCodingSystem() {
       ST ret = null;
       try {
          ret = (ST)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns alternate identifier (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getAlternateIdentifier() {
       ST ret = null;
       try {
          ret = (ST)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns alternate identifier (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCwe4_AlternateIdentifier() {
       ST ret = null;
       try {
          ret = (ST)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns alternate text (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getAlternateText() {
       ST ret = null;
       try {
          ret = (ST)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns alternate text (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCwe5_AlternateText() {
       ST ret = null;
       try {
          ret = (ST)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns name of alternate coding system (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getNameOfAlternateCodingSystem() {
       ST ret = null;
       try {
          ret = (ST)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns name of alternate coding system (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCwe6_NameOfAlternateCodingSystem() {
       ST ret = null;
       try {
          ret = (ST)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns coding system version ID (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCodingSystemVersionID() {
       ST ret = null;
       try {
          ret = (ST)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns coding system version ID (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCwe7_CodingSystemVersionID() {
       ST ret = null;
       try {
          ret = (ST)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns alternate coding system version ID (component #8).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getAlternateCodingSystemVersionID() {
       ST ret = null;
       try {
          ret = (ST)getComponent(7);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns alternate coding system version ID (component #8).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCwe8_AlternateCodingSystemVersionID() {
       ST ret = null;
       try {
          ret = (ST)getComponent(7);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns original text (component #9).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getOriginalText() {
       ST ret = null;
       try {
          ret = (ST)getComponent(8);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns original text (component #9).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCwe9_OriginalText() {
       ST ret = null;
       try {
          ret = (ST)getComponent(8);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

