/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 CX (extended composite ID with check digit) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>ID (ST)
 * <li>check digit (ST)
 * <li>code identifying the check digit scheme employed (ID)
 * <li>assigning authority (HD)
 * <li>identifier type code (IS)
 * <li>assigning facility (HD)
 * </ul>
 */
public class CX extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new CX type
     */
    public CX(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[6];    
        data[0] = new ST(getMessage());
        data[1] = new ST(getMessage());
        data[2] = new ID(getMessage(), 0);
        data[3] = new HD(getMessage());
        data[4] = new IS(getMessage(), 203);
        data[5] = new HD(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns ID (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getID() {
       ST ret = null;
       try {
          ret = (ST)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns ID (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCx1_ID() {
       ST ret = null;
       try {
          ret = (ST)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns check digit (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCheckDigit() {
       ST ret = null;
       try {
          ret = (ST)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns check digit (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCx2_CheckDigit() {
       ST ret = null;
       try {
          ret = (ST)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns code identifying the check digit scheme employed (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCodeIdentifyingTheCheckDigitSchemeEmployed() {
       ID ret = null;
       try {
          ret = (ID)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns code identifying the check digit scheme employed (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCx3_CodeIdentifyingTheCheckDigitSchemeEmployed() {
       ID ret = null;
       try {
          ret = (ID)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns assigning authority (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public HD getAssigningAuthority() {
       HD ret = null;
       try {
          ret = (HD)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns assigning authority (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public HD getCx4_AssigningAuthority() {
       HD ret = null;
       try {
          ret = (HD)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns identifier type code (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getIdentifierTypeCode() {
       IS ret = null;
       try {
          ret = (IS)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns identifier type code (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getCx5_IdentifierTypeCode() {
       IS ret = null;
       try {
          ret = (IS)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns assigning facility (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public HD getAssigningFacility() {
       HD ret = null;
       try {
          ret = (HD)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns assigning facility (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public HD getCx6_AssigningFacility() {
       HD ret = null;
       try {
          ret = (HD)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

