/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 ED (encapsulated data) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>source application (HD)
 * <li>type of data (ID)
 * <li>data subtype (ID)
 * <li>encoding (ID)
 * <li>data (ST)
 * </ul>
 */
public class ED extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new ED type
     */
    public ED(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[5];    
        data[0] = new HD(getMessage());
        data[1] = new ID(getMessage(), 191);
        data[2] = new ID(getMessage(), 291);
        data[3] = new ID(getMessage(), 299);
        data[4] = new ST(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns source application (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public HD getSourceApplication() {
       HD ret = null;
       try {
          ret = (HD)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns source application (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public HD getEd1_SourceApplication() {
       HD ret = null;
       try {
          ret = (HD)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns type of data (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getTypeOfData() {
       ID ret = null;
       try {
          ret = (ID)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns type of data (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getEd2_TypeOfData() {
       ID ret = null;
       try {
          ret = (ID)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns data subtype (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getDataSubtype() {
       ID ret = null;
       try {
          ret = (ID)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns data subtype (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getEd3_DataSubtype() {
       ID ret = null;
       try {
          ret = (ID)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns encoding (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getEncoding() {
       ID ret = null;
       try {
          ret = (ID)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns encoding (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getEd4_Encoding() {
       ID ret = null;
       try {
          ret = (ID)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns data (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getData() {
       ST ret = null;
       try {
          ret = (ST)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns data (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getEd5_Data() {
       ST ret = null;
       try {
          ret = (ST)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

