/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 ELD (error) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>segment ID (ST)
 * <li>sequence (NM)
 * <li>field position (NM)
 * <li>code identifying error (CE)
 * </ul>
 */
public class ELD extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new ELD type
     */
    public ELD(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[4];    
        data[0] = new ST(getMessage());
        data[1] = new NM(getMessage());
        data[2] = new NM(getMessage());
        data[3] = new CE(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns segment ID (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getSegmentID() {
       ST ret = null;
       try {
          ret = (ST)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns segment ID (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getEld1_SegmentID() {
       ST ret = null;
       try {
          ret = (ST)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns sequence (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getSequence() {
       NM ret = null;
       try {
          ret = (NM)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns sequence (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getEld2_Sequence() {
       NM ret = null;
       try {
          ret = (NM)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns field position (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getFieldPosition() {
       NM ret = null;
       try {
          ret = (NM)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns field position (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getEld3_FieldPosition() {
       NM ret = null;
       try {
          ret = (NM)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns code identifying error (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CE getCodeIdentifyingError() {
       CE ret = null;
       try {
          ret = (CE)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns code identifying error (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CE getEld4_CodeIdentifyingError() {
       CE ret = null;
       try {
          ret = (CE)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

