/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 NDL (observing practitioner) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>OP name (CN)
 * <li>start date/time (TS)
 * <li>end date/time (TS)
 * <li>point of care (IS) (IS)
 * <li>room (IS)
 * <li>bed (IS)
 * <li>facility (HD) (HD)
 * <li>location status (IS)
 * <li>person location type (IS)
 * <li>building (IS)
 * <li>floor (IS)
 * </ul>
 */
public class NDL extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new NDL type
     */
    public NDL(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[11];    
        data[0] = new CN(getMessage());
        data[1] = new TS(getMessage());
        data[2] = new TS(getMessage());
        data[3] = new IS(getMessage(), 0);
        data[4] = new IS(getMessage(), 0);
        data[5] = new IS(getMessage(), 0);
        data[6] = new HD(getMessage());
        data[7] = new IS(getMessage(), 0);
        data[8] = new IS(getMessage(), 0);
        data[9] = new IS(getMessage(), 0);
        data[10] = new IS(getMessage(), 0);
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns OP name (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CN getOPName() {
       CN ret = null;
       try {
          ret = (CN)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns OP name (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CN getNdl1_OPName() {
       CN ret = null;
       try {
          ret = (CN)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns start date/time (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TS getStartDateTime() {
       TS ret = null;
       try {
          ret = (TS)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns start date/time (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TS getNdl2_StartDateTime() {
       TS ret = null;
       try {
          ret = (TS)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns end date/time (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TS getEndDateTime() {
       TS ret = null;
       try {
          ret = (TS)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns end date/time (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TS getNdl3_EndDateTime() {
       TS ret = null;
       try {
          ret = (TS)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns point of care (IS) (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getPointOfCare() {
       IS ret = null;
       try {
          ret = (IS)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns point of care (IS) (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getNdl4_PointOfCare() {
       IS ret = null;
       try {
          ret = (IS)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns room (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getRoom() {
       IS ret = null;
       try {
          ret = (IS)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns room (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getNdl5_Room() {
       IS ret = null;
       try {
          ret = (IS)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns bed (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getBed() {
       IS ret = null;
       try {
          ret = (IS)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns bed (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getNdl6_Bed() {
       IS ret = null;
       try {
          ret = (IS)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns facility (HD) (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public HD getFacility() {
       HD ret = null;
       try {
          ret = (HD)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns facility (HD) (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public HD getNdl7_Facility() {
       HD ret = null;
       try {
          ret = (HD)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns location status (component #8).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getLocationStatus() {
       IS ret = null;
       try {
          ret = (IS)getComponent(7);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns location status (component #8).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getNdl8_LocationStatus() {
       IS ret = null;
       try {
          ret = (IS)getComponent(7);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns person location type (component #9).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getPersonLocationType() {
       IS ret = null;
       try {
          ret = (IS)getComponent(8);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns person location type (component #9).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getNdl9_PersonLocationType() {
       IS ret = null;
       try {
          ret = (IS)getComponent(8);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns building (component #10).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getBuilding() {
       IS ret = null;
       try {
          ret = (IS)getComponent(9);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns building (component #10).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getNdl10_Building() {
       IS ret = null;
       try {
          ret = (IS)getComponent(9);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns floor (component #11).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getFloor() {
       IS ret = null;
       try {
          ret = (IS)getComponent(10);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns floor (component #11).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getNdl11_Floor() {
       IS ret = null;
       try {
          ret = (IS)getComponent(10);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

