/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 TQ (timing quantity) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>quantity (CQ)
 * <li>interval (RI)
 * <li>duration (ST)
 * <li>start date/time (TS)
 * <li>end date/time (TS)
 * <li>priority (ST)
 * <li>condition (ST)
 * <li>text (ST)
 * <li>conjunction (ST)
 * <li>order sequencing (OSD)
 * <li>occurrence duration (CE)
 * <li>total occurences (NM)
 * </ul>
 */
public class TQ extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new TQ type
     */
    public TQ(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[12];    
        data[0] = new CQ(getMessage());
        data[1] = new RI(getMessage());
        data[2] = new ST(getMessage());
        data[3] = new TS(getMessage());
        data[4] = new TS(getMessage());
        data[5] = new ST(getMessage());
        data[6] = new ST(getMessage());
        data[7] = new ST(getMessage());
        data[8] = new ST(getMessage());
        data[9] = new OSD(getMessage());
        data[10] = new CE(getMessage());
        data[11] = new NM(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns quantity (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CQ getQuantity() {
       CQ ret = null;
       try {
          ret = (CQ)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns quantity (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CQ getTq1_Quantity() {
       CQ ret = null;
       try {
          ret = (CQ)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns interval (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public RI getInterval() {
       RI ret = null;
       try {
          ret = (RI)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns interval (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public RI getTq2_Interval() {
       RI ret = null;
       try {
          ret = (RI)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns duration (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getDuration() {
       ST ret = null;
       try {
          ret = (ST)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns duration (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getTq3_Duration() {
       ST ret = null;
       try {
          ret = (ST)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns start date/time (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TS getStartDateTime() {
       TS ret = null;
       try {
          ret = (TS)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns start date/time (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TS getTq4_StartDateTime() {
       TS ret = null;
       try {
          ret = (TS)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns end date/time (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TS getEndDateTime() {
       TS ret = null;
       try {
          ret = (TS)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns end date/time (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TS getTq5_EndDateTime() {
       TS ret = null;
       try {
          ret = (TS)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns priority (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getPriority() {
       ST ret = null;
       try {
          ret = (ST)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns priority (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getTq6_Priority() {
       ST ret = null;
       try {
          ret = (ST)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns condition (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCondition() {
       ST ret = null;
       try {
          ret = (ST)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns condition (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getTq7_Condition() {
       ST ret = null;
       try {
          ret = (ST)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns text (component #8).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getText() {
       ST ret = null;
       try {
          ret = (ST)getComponent(7);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns text (component #8).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getTq8_Text() {
       ST ret = null;
       try {
          ret = (ST)getComponent(7);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns conjunction (component #9).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getConjunction() {
       ST ret = null;
       try {
          ret = (ST)getComponent(8);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns conjunction (component #9).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getTq9_Conjunction() {
       ST ret = null;
       try {
          ret = (ST)getComponent(8);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns order sequencing (component #10).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public OSD getOrderSequencing() {
       OSD ret = null;
       try {
          ret = (OSD)getComponent(9);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns order sequencing (component #10).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public OSD getTq10_OrderSequencing() {
       OSD ret = null;
       try {
          ret = (OSD)getComponent(9);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns occurrence duration (component #11).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CE getOccurrenceDuration() {
       CE ret = null;
       try {
          ret = (CE)getComponent(10);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns occurrence duration (component #11).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CE getTq11_OccurrenceDuration() {
       CE ret = null;
       try {
          ret = (CE)getComponent(10);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns total occurences (component #12).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getTotalOccurences() {
       NM ret = null;
       try {
          ret = (NM)getComponent(11);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns total occurences (component #12).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getTq12_TotalOccurences() {
       NM ret = null;
       try {
          ret = (NM)getComponent(11);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

