/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a CSU_C09_CSPCSSORCOBROBXORCRXARXR group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: CSP (CSP - clinical study phase segment) <b>optional </b></li>
                 * <li>2: CSU_C09_CSSORCOBROBXORCRXARXR (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class CSU_C09_CSPCSSORCOBROBXORCRXARXR extends AbstractGroup {

    /** 
     * Creates a new CSU_C09_CSPCSSORCOBROBXORCRXARXR group
     */
    public CSU_C09_CSPCSSORCOBROBXORCRXARXR(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(CSP.class, false, false);
                          this.add(CSU_C09_CSSORCOBROBXORCRXARXR.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating CSU_C09_CSPCSSORCOBROBXORCRXARXR - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * CSP (CSP - clinical study phase segment) - creates it if necessary
     */
    public CSP getCSP() { 
       CSP ret = null;
       try {
          ret = (CSP)this.get("CSP");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * CSSORCOBROBXORCRXARXR (a Group object) - creates it if necessary
     */
    public CSU_C09_CSSORCOBROBXORCRXARXR getCSSORCOBROBXORCRXARXR() { 
       CSU_C09_CSSORCOBROBXORCRXARXR ret = null;
       try {
          ret = (CSU_C09_CSSORCOBROBXORCRXARXR)this.get("CSSORCOBROBXORCRXARXR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * CSSORCOBROBXORCRXARXR (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public CSU_C09_CSSORCOBROBXORCRXARXR getCSSORCOBROBXORCRXARXR(int rep) { 
       CSU_C09_CSSORCOBROBXORCRXARXR ret = null;
       try {
          ret = (CSU_C09_CSSORCOBROBXORCRXARXR)this.get("CSSORCOBROBXORCRXARXR", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of CSSORCOBROBXORCRXARXR 
     */ 
    public int getCSSORCOBROBXORCRXARXRReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("CSSORCOBROBXORCRXARXR").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of CSSORCOBROBXORCRXARXR (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertCSSORCOBROBXORCRXARXR(CSU_C09_CSSORCOBROBXORCRXARXR structure, int rep) throws HL7Exception { 
       super.insertRepetition("CSSORCOBROBXORCRXARXR", structure, rep);
    }


    /**
     * Inserts a specific repetition of CSSORCOBROBXORCRXARXR (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public CSU_C09_CSSORCOBROBXORCRXARXR insertCSSORCOBROBXORCRXARXR(int rep) throws HL7Exception { 
       return (CSU_C09_CSSORCOBROBXORCRXARXR)super.insertRepetition("CSSORCOBROBXORCRXARXR", rep);
    }


    /**
     * Removes a specific repetition of CSSORCOBROBXORCRXARXR (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public CSU_C09_CSSORCOBROBXORCRXARXR removeCSSORCOBROBXORCRXARXR(int rep) throws HL7Exception { 
       return (CSU_C09_CSSORCOBROBXORCRXARXR)super.removeRepetition("CSSORCOBROBXORCRXARXR", rep);
    }



}

