/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a CSU_C09_CSSORCOBROBXORCRXARXR group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: CSS (CSS - clinical study data schedule segment) <b>optional </b></li>
                 * <li>2: CSU_C09_ORCOBROBX (a Group object) <b> repeating</b></li>
                 * <li>3: CSU_C09_ORCRXARXR (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class CSU_C09_CSSORCOBROBXORCRXARXR extends AbstractGroup {

    /** 
     * Creates a new CSU_C09_CSSORCOBROBXORCRXARXR group
     */
    public CSU_C09_CSSORCOBROBXORCRXARXR(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(CSS.class, false, false);
                          this.add(CSU_C09_ORCOBROBX.class, true, true);
                          this.add(CSU_C09_ORCRXARXR.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating CSU_C09_CSSORCOBROBXORCRXARXR - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * CSS (CSS - clinical study data schedule segment) - creates it if necessary
     */
    public CSS getCSS() { 
       CSS ret = null;
       try {
          ret = (CSS)this.get("CSS");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * ORCOBROBX (a Group object) - creates it if necessary
     */
    public CSU_C09_ORCOBROBX getORCOBROBX() { 
       CSU_C09_ORCOBROBX ret = null;
       try {
          ret = (CSU_C09_ORCOBROBX)this.get("ORCOBROBX");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ORCOBROBX (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public CSU_C09_ORCOBROBX getORCOBROBX(int rep) { 
       CSU_C09_ORCOBROBX ret = null;
       try {
          ret = (CSU_C09_ORCOBROBX)this.get("ORCOBROBX", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ORCOBROBX 
     */ 
    public int getORCOBROBXReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ORCOBROBX").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ORCOBROBX (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertORCOBROBX(CSU_C09_ORCOBROBX structure, int rep) throws HL7Exception { 
       super.insertRepetition("ORCOBROBX", structure, rep);
    }


    /**
     * Inserts a specific repetition of ORCOBROBX (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public CSU_C09_ORCOBROBX insertORCOBROBX(int rep) throws HL7Exception { 
       return (CSU_C09_ORCOBROBX)super.insertRepetition("ORCOBROBX", rep);
    }


    /**
     * Removes a specific repetition of ORCOBROBX (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public CSU_C09_ORCOBROBX removeORCOBROBX(int rep) throws HL7Exception { 
       return (CSU_C09_ORCOBROBX)super.removeRepetition("ORCOBROBX", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * ORCRXARXR (a Group object) - creates it if necessary
     */
    public CSU_C09_ORCRXARXR getORCRXARXR() { 
       CSU_C09_ORCRXARXR ret = null;
       try {
          ret = (CSU_C09_ORCRXARXR)this.get("ORCRXARXR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ORCRXARXR (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public CSU_C09_ORCRXARXR getORCRXARXR(int rep) { 
       CSU_C09_ORCRXARXR ret = null;
       try {
          ret = (CSU_C09_ORCRXARXR)this.get("ORCRXARXR", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ORCRXARXR 
     */ 
    public int getORCRXARXRReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ORCRXARXR").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ORCRXARXR (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertORCRXARXR(CSU_C09_ORCRXARXR structure, int rep) throws HL7Exception { 
       super.insertRepetition("ORCRXARXR", structure, rep);
    }


    /**
     * Inserts a specific repetition of ORCRXARXR (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public CSU_C09_ORCRXARXR insertORCRXARXR(int rep) throws HL7Exception { 
       return (CSU_C09_ORCRXARXR)super.insertRepetition("ORCRXARXR", rep);
    }


    /**
     * Removes a specific repetition of ORCRXARXR (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public CSU_C09_ORCRXARXR removeORCRXARXR(int rep) throws HL7Exception { 
       return (CSU_C09_ORCRXARXR)super.removeRepetition("ORCRXARXR", rep);
    }



}

