/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a DFT_P03_FT1PR1ROL group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: FT1 (FT1 - financial transaction segment) <b> </b></li>
                 * <li>2: DFT_P03_PR1ROL (a Group object) <b>optional repeating</b></li>
 * </ul>
 */
public class DFT_P03_FT1PR1ROL extends AbstractGroup {

    /** 
     * Creates a new DFT_P03_FT1PR1ROL group
     */
    public DFT_P03_FT1PR1ROL(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(FT1.class, true, false);
                          this.add(DFT_P03_PR1ROL.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating DFT_P03_FT1PR1ROL - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * FT1 (FT1 - financial transaction segment) - creates it if necessary
     */
    public FT1 getFT1() { 
       FT1 ret = null;
       try {
          ret = (FT1)this.get("FT1");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * PR1ROL (a Group object) - creates it if necessary
     */
    public DFT_P03_PR1ROL getPR1ROL() { 
       DFT_P03_PR1ROL ret = null;
       try {
          ret = (DFT_P03_PR1ROL)this.get("PR1ROL");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * PR1ROL (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public DFT_P03_PR1ROL getPR1ROL(int rep) { 
       DFT_P03_PR1ROL ret = null;
       try {
          ret = (DFT_P03_PR1ROL)this.get("PR1ROL", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of PR1ROL 
     */ 
    public int getPR1ROLReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("PR1ROL").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of PR1ROL (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertPR1ROL(DFT_P03_PR1ROL structure, int rep) throws HL7Exception { 
       super.insertRepetition("PR1ROL", structure, rep);
    }


    /**
     * Inserts a specific repetition of PR1ROL (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public DFT_P03_PR1ROL insertPR1ROL(int rep) throws HL7Exception { 
       return (DFT_P03_PR1ROL)super.insertRepetition("PR1ROL", rep);
    }


    /**
     * Removes a specific repetition of PR1ROL (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public DFT_P03_PR1ROL removePR1ROL(int rep) throws HL7Exception { 
       return (DFT_P03_PR1ROL)super.removeRepetition("PR1ROL", rep);
    }



}

