/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a MFN_M06_MFECM0CM1CM2 group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: MFE (MFE - master file entry segment) <b> </b></li>
                 * <li>2: CM0 (CM0 - clinical study master segment) <b> </b></li>
                 * <li>3: MFN_M06_CM1CM2 (a Group object) <b>optional repeating</b></li>
 * </ul>
 */
public class MFN_M06_MFECM0CM1CM2 extends AbstractGroup {

    /** 
     * Creates a new MFN_M06_MFECM0CM1CM2 group
     */
    public MFN_M06_MFECM0CM1CM2(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MFE.class, true, false);
                          this.add(CM0.class, true, false);
                          this.add(MFN_M06_CM1CM2.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating MFN_M06_MFECM0CM1CM2 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * MFE (MFE - master file entry segment) - creates it if necessary
     */
    public MFE getMFE() { 
       MFE ret = null;
       try {
          ret = (MFE)this.get("MFE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * CM0 (CM0 - clinical study master segment) - creates it if necessary
     */
    public CM0 getCM0() { 
       CM0 ret = null;
       try {
          ret = (CM0)this.get("CM0");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * CM1CM2 (a Group object) - creates it if necessary
     */
    public MFN_M06_CM1CM2 getCM1CM2() { 
       MFN_M06_CM1CM2 ret = null;
       try {
          ret = (MFN_M06_CM1CM2)this.get("CM1CM2");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * CM1CM2 (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public MFN_M06_CM1CM2 getCM1CM2(int rep) { 
       MFN_M06_CM1CM2 ret = null;
       try {
          ret = (MFN_M06_CM1CM2)this.get("CM1CM2", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of CM1CM2 
     */ 
    public int getCM1CM2Reps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("CM1CM2").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of CM1CM2 (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertCM1CM2(MFN_M06_CM1CM2 structure, int rep) throws HL7Exception { 
       super.insertRepetition("CM1CM2", structure, rep);
    }


    /**
     * Inserts a specific repetition of CM1CM2 (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public MFN_M06_CM1CM2 insertCM1CM2(int rep) throws HL7Exception { 
       return (MFN_M06_CM1CM2)super.insertRepetition("CM1CM2", rep);
    }


    /**
     * Removes a specific repetition of CM1CM2 (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public MFN_M06_CM1CM2 removeCM1CM2(int rep) throws HL7Exception { 
       return (MFN_M06_CM1CM2)super.removeRepetition("CM1CM2", rep);
    }



}

