/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a ORD_O02_PIDNTEORCODSNTEORCODTNTE group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: ORD_O02_PIDNTE (a Group object) <b>optional </b></li>
                 * <li>2: ORD_O02_ORCODSNTE (a Group object) <b> repeating</b></li>
                 * <li>3: ORD_O02_ORCODTNTE (a Group object) <b>optional repeating</b></li>
 * </ul>
 */
public class ORD_O02_PIDNTEORCODSNTEORCODTNTE extends AbstractGroup {

    /** 
     * Creates a new ORD_O02_PIDNTEORCODSNTEORCODTNTE group
     */
    public ORD_O02_PIDNTEORCODSNTEORCODTNTE(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(ORD_O02_PIDNTE.class, false, false);
                          this.add(ORD_O02_ORCODSNTE.class, true, true);
                          this.add(ORD_O02_ORCODTNTE.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ORD_O02_PIDNTEORCODSNTEORCODTNTE - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * PIDNTE (a Group object) - creates it if necessary
     */
    public ORD_O02_PIDNTE getPIDNTE() { 
       ORD_O02_PIDNTE ret = null;
       try {
          ret = (ORD_O02_PIDNTE)this.get("PIDNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * ORCODSNTE (a Group object) - creates it if necessary
     */
    public ORD_O02_ORCODSNTE getORCODSNTE() { 
       ORD_O02_ORCODSNTE ret = null;
       try {
          ret = (ORD_O02_ORCODSNTE)this.get("ORCODSNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ORCODSNTE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public ORD_O02_ORCODSNTE getORCODSNTE(int rep) { 
       ORD_O02_ORCODSNTE ret = null;
       try {
          ret = (ORD_O02_ORCODSNTE)this.get("ORCODSNTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ORCODSNTE 
     */ 
    public int getORCODSNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ORCODSNTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ORCODSNTE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertORCODSNTE(ORD_O02_ORCODSNTE structure, int rep) throws HL7Exception { 
       super.insertRepetition("ORCODSNTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of ORCODSNTE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public ORD_O02_ORCODSNTE insertORCODSNTE(int rep) throws HL7Exception { 
       return (ORD_O02_ORCODSNTE)super.insertRepetition("ORCODSNTE", rep);
    }


    /**
     * Removes a specific repetition of ORCODSNTE (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public ORD_O02_ORCODSNTE removeORCODSNTE(int rep) throws HL7Exception { 
       return (ORD_O02_ORCODSNTE)super.removeRepetition("ORCODSNTE", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * ORCODTNTE (a Group object) - creates it if necessary
     */
    public ORD_O02_ORCODTNTE getORCODTNTE() { 
       ORD_O02_ORCODTNTE ret = null;
       try {
          ret = (ORD_O02_ORCODTNTE)this.get("ORCODTNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ORCODTNTE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public ORD_O02_ORCODTNTE getORCODTNTE(int rep) { 
       ORD_O02_ORCODTNTE ret = null;
       try {
          ret = (ORD_O02_ORCODTNTE)this.get("ORCODTNTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ORCODTNTE 
     */ 
    public int getORCODTNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ORCODTNTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ORCODTNTE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertORCODTNTE(ORD_O02_ORCODTNTE structure, int rep) throws HL7Exception { 
       super.insertRepetition("ORCODTNTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of ORCODTNTE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public ORD_O02_ORCODTNTE insertORCODTNTE(int rep) throws HL7Exception { 
       return (ORD_O02_ORCODTNTE)super.insertRepetition("ORCODTNTE", rep);
    }


    /**
     * Removes a specific repetition of ORCODTNTE (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public ORD_O02_ORCODTNTE removeORCODTNTE(int rep) throws HL7Exception { 
       return (ORD_O02_ORCODTNTE)super.removeRepetition("ORCODTNTE", rep);
    }



}

