/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a ORF_R04_PIDNTEORCOBRNTEOBXNTECTI group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: ORF_R04_PIDNTE (a Group object) <b>optional </b></li>
                 * <li>2: ORF_R04_ORCOBRNTEOBXNTECTI (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class ORF_R04_PIDNTEORCOBRNTEOBXNTECTI extends AbstractGroup {

    /** 
     * Creates a new ORF_R04_PIDNTEORCOBRNTEOBXNTECTI group
     */
    public ORF_R04_PIDNTEORCOBRNTEOBXNTECTI(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(ORF_R04_PIDNTE.class, false, false);
                          this.add(ORF_R04_ORCOBRNTEOBXNTECTI.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ORF_R04_PIDNTEORCOBRNTEOBXNTECTI - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * PIDNTE (a Group object) - creates it if necessary
     */
    public ORF_R04_PIDNTE getPIDNTE() { 
       ORF_R04_PIDNTE ret = null;
       try {
          ret = (ORF_R04_PIDNTE)this.get("PIDNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * ORCOBRNTEOBXNTECTI (a Group object) - creates it if necessary
     */
    public ORF_R04_ORCOBRNTEOBXNTECTI getORCOBRNTEOBXNTECTI() { 
       ORF_R04_ORCOBRNTEOBXNTECTI ret = null;
       try {
          ret = (ORF_R04_ORCOBRNTEOBXNTECTI)this.get("ORCOBRNTEOBXNTECTI");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ORCOBRNTEOBXNTECTI (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public ORF_R04_ORCOBRNTEOBXNTECTI getORCOBRNTEOBXNTECTI(int rep) { 
       ORF_R04_ORCOBRNTEOBXNTECTI ret = null;
       try {
          ret = (ORF_R04_ORCOBRNTEOBXNTECTI)this.get("ORCOBRNTEOBXNTECTI", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ORCOBRNTEOBXNTECTI 
     */ 
    public int getORCOBRNTEOBXNTECTIReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ORCOBRNTEOBXNTECTI").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ORCOBRNTEOBXNTECTI (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertORCOBRNTEOBXNTECTI(ORF_R04_ORCOBRNTEOBXNTECTI structure, int rep) throws HL7Exception { 
       super.insertRepetition("ORCOBRNTEOBXNTECTI", structure, rep);
    }


    /**
     * Inserts a specific repetition of ORCOBRNTEOBXNTECTI (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public ORF_R04_ORCOBRNTEOBXNTECTI insertORCOBRNTEOBXNTECTI(int rep) throws HL7Exception { 
       return (ORF_R04_ORCOBRNTEOBXNTECTI)super.insertRepetition("ORCOBRNTEOBXNTECTI", rep);
    }


    /**
     * Removes a specific repetition of ORCOBRNTEOBXNTECTI (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public ORF_R04_ORCOBRNTEOBXNTECTI removeORCOBRNTEOBXNTECTI(int rep) throws HL7Exception { 
       return (ORF_R04_ORCOBRNTEOBXNTECTI)super.removeRepetition("ORCOBRNTEOBXNTECTI", rep);
    }



}

