/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a ORN_O02_PIDNTEORCRQDRQ1NTE group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: ORN_O02_PIDNTE (a Group object) <b>optional </b></li>
                 * <li>2: ORN_O02_ORCRQDRQ1NTE (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class ORN_O02_PIDNTEORCRQDRQ1NTE extends AbstractGroup {

    /** 
     * Creates a new ORN_O02_PIDNTEORCRQDRQ1NTE group
     */
    public ORN_O02_PIDNTEORCRQDRQ1NTE(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(ORN_O02_PIDNTE.class, false, false);
                          this.add(ORN_O02_ORCRQDRQ1NTE.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ORN_O02_PIDNTEORCRQDRQ1NTE - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * PIDNTE (a Group object) - creates it if necessary
     */
    public ORN_O02_PIDNTE getPIDNTE() { 
       ORN_O02_PIDNTE ret = null;
       try {
          ret = (ORN_O02_PIDNTE)this.get("PIDNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * ORCRQDRQ1NTE (a Group object) - creates it if necessary
     */
    public ORN_O02_ORCRQDRQ1NTE getORCRQDRQ1NTE() { 
       ORN_O02_ORCRQDRQ1NTE ret = null;
       try {
          ret = (ORN_O02_ORCRQDRQ1NTE)this.get("ORCRQDRQ1NTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ORCRQDRQ1NTE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public ORN_O02_ORCRQDRQ1NTE getORCRQDRQ1NTE(int rep) { 
       ORN_O02_ORCRQDRQ1NTE ret = null;
       try {
          ret = (ORN_O02_ORCRQDRQ1NTE)this.get("ORCRQDRQ1NTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ORCRQDRQ1NTE 
     */ 
    public int getORCRQDRQ1NTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ORCRQDRQ1NTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ORCRQDRQ1NTE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertORCRQDRQ1NTE(ORN_O02_ORCRQDRQ1NTE structure, int rep) throws HL7Exception { 
       super.insertRepetition("ORCRQDRQ1NTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of ORCRQDRQ1NTE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public ORN_O02_ORCRQDRQ1NTE insertORCRQDRQ1NTE(int rep) throws HL7Exception { 
       return (ORN_O02_ORCRQDRQ1NTE)super.insertRepetition("ORCRQDRQ1NTE", rep);
    }


    /**
     * Removes a specific repetition of ORCRQDRQ1NTE (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public ORN_O02_ORCRQDRQ1NTE removeORCRQDRQ1NTE(int rep) throws HL7Exception { 
       return (ORN_O02_ORCRQDRQ1NTE)super.removeRepetition("ORCRQDRQ1NTE", rep);
    }



}

