/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a ORR_O02_PIDNTEORCOBRRQDRQ1RXOODSODTNTECTI group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: ORR_O02_PIDNTE (a Group object) <b>optional </b></li>
                 * <li>2: ORR_O02_ORCOBRRQDRQ1RXOODSODTNTECTI (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class ORR_O02_PIDNTEORCOBRRQDRQ1RXOODSODTNTECTI extends AbstractGroup {

    /** 
     * Creates a new ORR_O02_PIDNTEORCOBRRQDRQ1RXOODSODTNTECTI group
     */
    public ORR_O02_PIDNTEORCOBRRQDRQ1RXOODSODTNTECTI(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(ORR_O02_PIDNTE.class, false, false);
                          this.add(ORR_O02_ORCOBRRQDRQ1RXOODSODTNTECTI.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ORR_O02_PIDNTEORCOBRRQDRQ1RXOODSODTNTECTI - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * PIDNTE (a Group object) - creates it if necessary
     */
    public ORR_O02_PIDNTE getPIDNTE() { 
       ORR_O02_PIDNTE ret = null;
       try {
          ret = (ORR_O02_PIDNTE)this.get("PIDNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * ORCOBRRQDRQ1RXOODSODTNTECTI (a Group object) - creates it if necessary
     */
    public ORR_O02_ORCOBRRQDRQ1RXOODSODTNTECTI getORCOBRRQDRQ1RXOODSODTNTECTI() { 
       ORR_O02_ORCOBRRQDRQ1RXOODSODTNTECTI ret = null;
       try {
          ret = (ORR_O02_ORCOBRRQDRQ1RXOODSODTNTECTI)this.get("ORCOBRRQDRQ1RXOODSODTNTECTI");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ORCOBRRQDRQ1RXOODSODTNTECTI (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public ORR_O02_ORCOBRRQDRQ1RXOODSODTNTECTI getORCOBRRQDRQ1RXOODSODTNTECTI(int rep) { 
       ORR_O02_ORCOBRRQDRQ1RXOODSODTNTECTI ret = null;
       try {
          ret = (ORR_O02_ORCOBRRQDRQ1RXOODSODTNTECTI)this.get("ORCOBRRQDRQ1RXOODSODTNTECTI", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ORCOBRRQDRQ1RXOODSODTNTECTI 
     */ 
    public int getORCOBRRQDRQ1RXOODSODTNTECTIReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ORCOBRRQDRQ1RXOODSODTNTECTI").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ORCOBRRQDRQ1RXOODSODTNTECTI (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertORCOBRRQDRQ1RXOODSODTNTECTI(ORR_O02_ORCOBRRQDRQ1RXOODSODTNTECTI structure, int rep) throws HL7Exception { 
       super.insertRepetition("ORCOBRRQDRQ1RXOODSODTNTECTI", structure, rep);
    }


    /**
     * Inserts a specific repetition of ORCOBRRQDRQ1RXOODSODTNTECTI (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public ORR_O02_ORCOBRRQDRQ1RXOODSODTNTECTI insertORCOBRRQDRQ1RXOODSODTNTECTI(int rep) throws HL7Exception { 
       return (ORR_O02_ORCOBRRQDRQ1RXOODSODTNTECTI)super.insertRepetition("ORCOBRRQDRQ1RXOODSODTNTECTI", rep);
    }


    /**
     * Removes a specific repetition of ORCOBRRQDRQ1RXOODSODTNTECTI (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public ORR_O02_ORCOBRRQDRQ1RXOODSODTNTECTI removeORCOBRRQDRQ1RXOODSODTNTECTI(int rep) throws HL7Exception { 
       return (ORR_O02_ORCOBRRQDRQ1RXOODSODTNTECTI)super.removeRepetition("ORCOBRRQDRQ1RXOODSODTNTECTI", rep);
    }



}

