/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a ORU_R01_PIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: ORU_R01_PIDPD1NK1NTEPV1PV2 (a Group object) <b>optional </b></li>
                 * <li>2: ORU_R01_ORCOBRNTEOBXNTECTI (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class ORU_R01_PIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI extends AbstractGroup {

    /** 
     * Creates a new ORU_R01_PIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI group
     */
    public ORU_R01_PIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(ORU_R01_PIDPD1NK1NTEPV1PV2.class, false, false);
                          this.add(ORU_R01_ORCOBRNTEOBXNTECTI.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ORU_R01_PIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * PIDPD1NK1NTEPV1PV2 (a Group object) - creates it if necessary
     */
    public ORU_R01_PIDPD1NK1NTEPV1PV2 getPIDPD1NK1NTEPV1PV2() { 
       ORU_R01_PIDPD1NK1NTEPV1PV2 ret = null;
       try {
          ret = (ORU_R01_PIDPD1NK1NTEPV1PV2)this.get("PIDPD1NK1NTEPV1PV2");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * ORCOBRNTEOBXNTECTI (a Group object) - creates it if necessary
     */
    public ORU_R01_ORCOBRNTEOBXNTECTI getORCOBRNTEOBXNTECTI() { 
       ORU_R01_ORCOBRNTEOBXNTECTI ret = null;
       try {
          ret = (ORU_R01_ORCOBRNTEOBXNTECTI)this.get("ORCOBRNTEOBXNTECTI");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ORCOBRNTEOBXNTECTI (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public ORU_R01_ORCOBRNTEOBXNTECTI getORCOBRNTEOBXNTECTI(int rep) { 
       ORU_R01_ORCOBRNTEOBXNTECTI ret = null;
       try {
          ret = (ORU_R01_ORCOBRNTEOBXNTECTI)this.get("ORCOBRNTEOBXNTECTI", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ORCOBRNTEOBXNTECTI 
     */ 
    public int getORCOBRNTEOBXNTECTIReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ORCOBRNTEOBXNTECTI").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ORCOBRNTEOBXNTECTI (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertORCOBRNTEOBXNTECTI(ORU_R01_ORCOBRNTEOBXNTECTI structure, int rep) throws HL7Exception { 
       super.insertRepetition("ORCOBRNTEOBXNTECTI", structure, rep);
    }


    /**
     * Inserts a specific repetition of ORCOBRNTEOBXNTECTI (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public ORU_R01_ORCOBRNTEOBXNTECTI insertORCOBRNTEOBXNTECTI(int rep) throws HL7Exception { 
       return (ORU_R01_ORCOBRNTEOBXNTECTI)super.insertRepetition("ORCOBRNTEOBXNTECTI", rep);
    }


    /**
     * Removes a specific repetition of ORCOBRNTEOBXNTECTI (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public ORU_R01_ORCOBRNTEOBXNTECTI removeORCOBRNTEOBXNTECTI(int rep) throws HL7Exception { 
       return (ORU_R01_ORCOBRNTEOBXNTECTI)super.removeRepetition("ORCOBRNTEOBXNTECTI", rep);
    }



}

