/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a OSR_Q06_PIDNTEORCOBRRXORQDRQ1ODSODTNTECTI group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: OSR_Q06_PIDNTE (a Group object) <b>optional </b></li>
                 * <li>2: OSR_Q06_ORCOBRRXORQDRQ1ODSODTNTECTI (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class OSR_Q06_PIDNTEORCOBRRXORQDRQ1ODSODTNTECTI extends AbstractGroup {

    /** 
     * Creates a new OSR_Q06_PIDNTEORCOBRRXORQDRQ1ODSODTNTECTI group
     */
    public OSR_Q06_PIDNTEORCOBRRXORQDRQ1ODSODTNTECTI(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(OSR_Q06_PIDNTE.class, false, false);
                          this.add(OSR_Q06_ORCOBRRXORQDRQ1ODSODTNTECTI.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating OSR_Q06_PIDNTEORCOBRRXORQDRQ1ODSODTNTECTI - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * PIDNTE (a Group object) - creates it if necessary
     */
    public OSR_Q06_PIDNTE getPIDNTE() { 
       OSR_Q06_PIDNTE ret = null;
       try {
          ret = (OSR_Q06_PIDNTE)this.get("PIDNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * ORCOBRRXORQDRQ1ODSODTNTECTI (a Group object) - creates it if necessary
     */
    public OSR_Q06_ORCOBRRXORQDRQ1ODSODTNTECTI getORCOBRRXORQDRQ1ODSODTNTECTI() { 
       OSR_Q06_ORCOBRRXORQDRQ1ODSODTNTECTI ret = null;
       try {
          ret = (OSR_Q06_ORCOBRRXORQDRQ1ODSODTNTECTI)this.get("ORCOBRRXORQDRQ1ODSODTNTECTI");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ORCOBRRXORQDRQ1ODSODTNTECTI (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public OSR_Q06_ORCOBRRXORQDRQ1ODSODTNTECTI getORCOBRRXORQDRQ1ODSODTNTECTI(int rep) { 
       OSR_Q06_ORCOBRRXORQDRQ1ODSODTNTECTI ret = null;
       try {
          ret = (OSR_Q06_ORCOBRRXORQDRQ1ODSODTNTECTI)this.get("ORCOBRRXORQDRQ1ODSODTNTECTI", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ORCOBRRXORQDRQ1ODSODTNTECTI 
     */ 
    public int getORCOBRRXORQDRQ1ODSODTNTECTIReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ORCOBRRXORQDRQ1ODSODTNTECTI").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ORCOBRRXORQDRQ1ODSODTNTECTI (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertORCOBRRXORQDRQ1ODSODTNTECTI(OSR_Q06_ORCOBRRXORQDRQ1ODSODTNTECTI structure, int rep) throws HL7Exception { 
       super.insertRepetition("ORCOBRRXORQDRQ1ODSODTNTECTI", structure, rep);
    }


    /**
     * Inserts a specific repetition of ORCOBRRXORQDRQ1ODSODTNTECTI (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public OSR_Q06_ORCOBRRXORQDRQ1ODSODTNTECTI insertORCOBRRXORQDRQ1ODSODTNTECTI(int rep) throws HL7Exception { 
       return (OSR_Q06_ORCOBRRXORQDRQ1ODSODTNTECTI)super.insertRepetition("ORCOBRRXORQDRQ1ODSODTNTECTI", rep);
    }


    /**
     * Removes a specific repetition of ORCOBRRXORQDRQ1ODSODTNTECTI (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public OSR_Q06_ORCOBRRXORQDRQ1ODSODTNTECTI removeORCOBRRXORQDRQ1ODSODTNTECTI(int rep) throws HL7Exception { 
       return (OSR_Q06_ORCOBRRXORQDRQ1ODSODTNTECTI)super.removeRepetition("ORCOBRRXORQDRQ1ODSODTNTECTI", rep);
    }



}

