/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a PEX_P07_PCRRXERXRRXARXRPRBOBXNTENK1RXERXRRXARXRPRBOBXCSRCSP group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: PCR (PCR - possible causal relationship segment) <b> </b></li>
                 * <li>2: PEX_P07_RXERXR (a Group object) <b>optional </b></li>
                 * <li>3: PEX_P07_RXARXR (a Group object) <b>optional repeating</b></li>
                 * <li>4: PRB (Problem Detail) <b>optional repeating</b></li>
                 * <li>5: OBX (OBX - observation/result segment) <b>optional repeating</b></li>
                 * <li>6: NTE (NTE - notes and comments segment) <b>optional repeating</b></li>
                 * <li>7: PEX_P07_NK1RXERXRRXARXRPRBOBX (a Group object) <b>optional </b></li>
                 * <li>8: PEX_P07_CSRCSP (a Group object) <b>optional repeating</b></li>
 * </ul>
 */
public class PEX_P07_PCRRXERXRRXARXRPRBOBXNTENK1RXERXRRXARXRPRBOBXCSRCSP extends AbstractGroup {

    /** 
     * Creates a new PEX_P07_PCRRXERXRRXARXRPRBOBXNTENK1RXERXRRXARXRPRBOBXCSRCSP group
     */
    public PEX_P07_PCRRXERXRRXARXRPRBOBXNTENK1RXERXRRXARXRPRBOBXCSRCSP(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(PCR.class, true, false);
                          this.add(PEX_P07_RXERXR.class, false, false);
                          this.add(PEX_P07_RXARXR.class, false, true);
                          this.add(PRB.class, false, true);
                          this.add(OBX.class, false, true);
                          this.add(NTE.class, false, true);
                          this.add(PEX_P07_NK1RXERXRRXARXRPRBOBX.class, false, false);
                          this.add(PEX_P07_CSRCSP.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PEX_P07_PCRRXERXRRXARXRPRBOBXNTENK1RXERXRRXARXRPRBOBXCSRCSP - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * PCR (PCR - possible causal relationship segment) - creates it if necessary
     */
    public PCR getPCR() { 
       PCR ret = null;
       try {
          ret = (PCR)this.get("PCR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * RXERXR (a Group object) - creates it if necessary
     */
    public PEX_P07_RXERXR getRXERXR() { 
       PEX_P07_RXERXR ret = null;
       try {
          ret = (PEX_P07_RXERXR)this.get("RXERXR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * RXARXR (a Group object) - creates it if necessary
     */
    public PEX_P07_RXARXR getRXARXR() { 
       PEX_P07_RXARXR ret = null;
       try {
          ret = (PEX_P07_RXARXR)this.get("RXARXR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * RXARXR (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public PEX_P07_RXARXR getRXARXR(int rep) { 
       PEX_P07_RXARXR ret = null;
       try {
          ret = (PEX_P07_RXARXR)this.get("RXARXR", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of RXARXR 
     */ 
    public int getRXARXRReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("RXARXR").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of RXARXR (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertRXARXR(PEX_P07_RXARXR structure, int rep) throws HL7Exception { 
       super.insertRepetition("RXARXR", structure, rep);
    }


    /**
     * Inserts a specific repetition of RXARXR (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public PEX_P07_RXARXR insertRXARXR(int rep) throws HL7Exception { 
       return (PEX_P07_RXARXR)super.insertRepetition("RXARXR", rep);
    }


    /**
     * Removes a specific repetition of RXARXR (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public PEX_P07_RXARXR removeRXARXR(int rep) throws HL7Exception { 
       return (PEX_P07_RXARXR)super.removeRepetition("RXARXR", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * PRB (Problem Detail) - creates it if necessary
     */
    public PRB getPRB() { 
       PRB ret = null;
       try {
          ret = (PRB)this.get("PRB");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * PRB (Problem Detail) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public PRB getPRB(int rep) { 
       PRB ret = null;
       try {
          ret = (PRB)this.get("PRB", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of PRB 
     */ 
    public int getPRBReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("PRB").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of PRB (Problem Detail)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertPRB(PRB structure, int rep) throws HL7Exception { 
       super.insertRepetition("PRB", structure, rep);
    }


    /**
     * Inserts a specific repetition of PRB (Problem Detail)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public PRB insertPRB(int rep) throws HL7Exception { 
       return (PRB)super.insertRepetition("PRB", rep);
    }


    /**
     * Removes a specific repetition of PRB (Problem Detail)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public PRB removePRB(int rep) throws HL7Exception { 
       return (PRB)super.removeRepetition("PRB", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * OBX (OBX - observation/result segment) - creates it if necessary
     */
    public OBX getOBX() { 
       OBX ret = null;
       try {
          ret = (OBX)this.get("OBX");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * OBX (OBX - observation/result segment) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public OBX getOBX(int rep) { 
       OBX ret = null;
       try {
          ret = (OBX)this.get("OBX", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of OBX 
     */ 
    public int getOBXReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("OBX").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of OBX (OBX - observation/result segment)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertOBX(OBX structure, int rep) throws HL7Exception { 
       super.insertRepetition("OBX", structure, rep);
    }


    /**
     * Inserts a specific repetition of OBX (OBX - observation/result segment)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public OBX insertOBX(int rep) throws HL7Exception { 
       return (OBX)super.insertRepetition("OBX", rep);
    }


    /**
     * Removes a specific repetition of OBX (OBX - observation/result segment)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public OBX removeOBX(int rep) throws HL7Exception { 
       return (OBX)super.removeRepetition("OBX", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * NTE (NTE - notes and comments segment) - creates it if necessary
     */
    public NTE getNTE() { 
       NTE ret = null;
       try {
          ret = (NTE)this.get("NTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * NTE (NTE - notes and comments segment) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public NTE getNTE(int rep) { 
       NTE ret = null;
       try {
          ret = (NTE)this.get("NTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of NTE 
     */ 
    public int getNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("NTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of NTE (NTE - notes and comments segment)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertNTE(NTE structure, int rep) throws HL7Exception { 
       super.insertRepetition("NTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of NTE (NTE - notes and comments segment)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public NTE insertNTE(int rep) throws HL7Exception { 
       return (NTE)super.insertRepetition("NTE", rep);
    }


    /**
     * Removes a specific repetition of NTE (NTE - notes and comments segment)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public NTE removeNTE(int rep) throws HL7Exception { 
       return (NTE)super.removeRepetition("NTE", rep);
    }



    /**
     * Returns
     * NK1RXERXRRXARXRPRBOBX (a Group object) - creates it if necessary
     */
    public PEX_P07_NK1RXERXRRXARXRPRBOBX getNK1RXERXRRXARXRPRBOBX() { 
       PEX_P07_NK1RXERXRRXARXRPRBOBX ret = null;
       try {
          ret = (PEX_P07_NK1RXERXRRXARXRPRBOBX)this.get("NK1RXERXRRXARXRPRBOBX");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * CSRCSP (a Group object) - creates it if necessary
     */
    public PEX_P07_CSRCSP getCSRCSP() { 
       PEX_P07_CSRCSP ret = null;
       try {
          ret = (PEX_P07_CSRCSP)this.get("CSRCSP");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * CSRCSP (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public PEX_P07_CSRCSP getCSRCSP(int rep) { 
       PEX_P07_CSRCSP ret = null;
       try {
          ret = (PEX_P07_CSRCSP)this.get("CSRCSP", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of CSRCSP 
     */ 
    public int getCSRCSPReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("CSRCSP").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of CSRCSP (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertCSRCSP(PEX_P07_CSRCSP structure, int rep) throws HL7Exception { 
       super.insertRepetition("CSRCSP", structure, rep);
    }


    /**
     * Inserts a specific repetition of CSRCSP (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public PEX_P07_CSRCSP insertCSRCSP(int rep) throws HL7Exception { 
       return (PEX_P07_CSRCSP)super.insertRepetition("CSRCSP", rep);
    }


    /**
     * Removes a specific repetition of CSRCSP (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public PEX_P07_CSRCSP removeCSRCSP(int rep) throws HL7Exception { 
       return (PEX_P07_CSRCSP)super.removeRepetition("CSRCSP", rep);
    }



}

