/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a RDR_RDR_QRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: QRD (QRD - original-style query definition segment) <b> </b></li>
                 * <li>2: QRF (QRF - original style query filter segment) <b>optional </b></li>
                 * <li>3: RDR_RDR_PIDNTE (a Group object) <b>optional </b></li>
                 * <li>4: RDR_RDR_ORCRXERXRRXCRXDRXRRXC (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class RDR_RDR_QRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC extends AbstractGroup {

    /** 
     * Creates a new RDR_RDR_QRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC group
     */
    public RDR_RDR_QRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(QRD.class, true, false);
                          this.add(QRF.class, false, false);
                          this.add(RDR_RDR_PIDNTE.class, false, false);
                          this.add(RDR_RDR_ORCRXERXRRXCRXDRXRRXC.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RDR_RDR_QRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * QRD (QRD - original-style query definition segment) - creates it if necessary
     */
    public QRD getQRD() { 
       QRD ret = null;
       try {
          ret = (QRD)this.get("QRD");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * QRF (QRF - original style query filter segment) - creates it if necessary
     */
    public QRF getQRF() { 
       QRF ret = null;
       try {
          ret = (QRF)this.get("QRF");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * PIDNTE (a Group object) - creates it if necessary
     */
    public RDR_RDR_PIDNTE getPIDNTE() { 
       RDR_RDR_PIDNTE ret = null;
       try {
          ret = (RDR_RDR_PIDNTE)this.get("PIDNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * ORCRXERXRRXCRXDRXRRXC (a Group object) - creates it if necessary
     */
    public RDR_RDR_ORCRXERXRRXCRXDRXRRXC getORCRXERXRRXCRXDRXRRXC() { 
       RDR_RDR_ORCRXERXRRXCRXDRXRRXC ret = null;
       try {
          ret = (RDR_RDR_ORCRXERXRRXCRXDRXRRXC)this.get("ORCRXERXRRXCRXDRXRRXC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ORCRXERXRRXCRXDRXRRXC (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public RDR_RDR_ORCRXERXRRXCRXDRXRRXC getORCRXERXRRXCRXDRXRRXC(int rep) { 
       RDR_RDR_ORCRXERXRRXCRXDRXRRXC ret = null;
       try {
          ret = (RDR_RDR_ORCRXERXRRXCRXDRXRRXC)this.get("ORCRXERXRRXCRXDRXRRXC", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ORCRXERXRRXCRXDRXRRXC 
     */ 
    public int getORCRXERXRRXCRXDRXRRXCReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ORCRXERXRRXCRXDRXRRXC").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ORCRXERXRRXCRXDRXRRXC (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertORCRXERXRRXCRXDRXRRXC(RDR_RDR_ORCRXERXRRXCRXDRXRRXC structure, int rep) throws HL7Exception { 
       super.insertRepetition("ORCRXERXRRXCRXDRXRRXC", structure, rep);
    }


    /**
     * Inserts a specific repetition of ORCRXERXRRXCRXDRXRRXC (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public RDR_RDR_ORCRXERXRRXCRXDRXRRXC insertORCRXERXRRXCRXDRXRRXC(int rep) throws HL7Exception { 
       return (RDR_RDR_ORCRXERXRRXCRXDRXRRXC)super.insertRepetition("ORCRXERXRRXCRXDRXRRXC", rep);
    }


    /**
     * Removes a specific repetition of ORCRXERXRRXCRXDRXRRXC (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public RDR_RDR_ORCRXERXRRXCRXDRXRRXC removeORCRXERXRRXCRXDRXRRXC(int rep) throws HL7Exception { 
       return (RDR_RDR_ORCRXERXRRXCRXDRXRRXC)super.removeRepetition("ORCRXERXRRXCRXDRXRRXC", rep);
    }



}

