/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a RDS_O01_RXONTERXRRXCNTE group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: RXO (RXO - pharmacy/treatment order segment) <b> </b></li>
                 * <li>2: RDS_O01_NTERXRRXCNTE (a Group object) <b>optional </b></li>
 * </ul>
 */
public class RDS_O01_RXONTERXRRXCNTE extends AbstractGroup {

    /** 
     * Creates a new RDS_O01_RXONTERXRRXCNTE group
     */
    public RDS_O01_RXONTERXRRXCNTE(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(RXO.class, true, false);
                          this.add(RDS_O01_NTERXRRXCNTE.class, false, false);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RDS_O01_RXONTERXRRXCNTE - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * RXO (RXO - pharmacy/treatment order segment) - creates it if necessary
     */
    public RXO getRXO() { 
       RXO ret = null;
       try {
          ret = (RXO)this.get("RXO");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * NTERXRRXCNTE (a Group object) - creates it if necessary
     */
    public RDS_O01_NTERXRRXCNTE getNTERXRRXCNTE() { 
       RDS_O01_NTERXRRXCNTE ret = null;
       try {
          ret = (RDS_O01_NTERXRRXCNTE)this.get("NTERXRRXCNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




}

