/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a RER_RER_QRDQRFPIDNTEORCRXERXRRXC group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: QRD (QRD - original-style query definition segment) <b> </b></li>
                 * <li>2: QRF (QRF - original style query filter segment) <b>optional </b></li>
                 * <li>3: RER_RER_PIDNTE (a Group object) <b>optional </b></li>
                 * <li>4: RER_RER_ORCRXERXRRXC (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class RER_RER_QRDQRFPIDNTEORCRXERXRRXC extends AbstractGroup {

    /** 
     * Creates a new RER_RER_QRDQRFPIDNTEORCRXERXRRXC group
     */
    public RER_RER_QRDQRFPIDNTEORCRXERXRRXC(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(QRD.class, true, false);
                          this.add(QRF.class, false, false);
                          this.add(RER_RER_PIDNTE.class, false, false);
                          this.add(RER_RER_ORCRXERXRRXC.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RER_RER_QRDQRFPIDNTEORCRXERXRRXC - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * QRD (QRD - original-style query definition segment) - creates it if necessary
     */
    public QRD getQRD() { 
       QRD ret = null;
       try {
          ret = (QRD)this.get("QRD");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * QRF (QRF - original style query filter segment) - creates it if necessary
     */
    public QRF getQRF() { 
       QRF ret = null;
       try {
          ret = (QRF)this.get("QRF");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * PIDNTE (a Group object) - creates it if necessary
     */
    public RER_RER_PIDNTE getPIDNTE() { 
       RER_RER_PIDNTE ret = null;
       try {
          ret = (RER_RER_PIDNTE)this.get("PIDNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * ORCRXERXRRXC (a Group object) - creates it if necessary
     */
    public RER_RER_ORCRXERXRRXC getORCRXERXRRXC() { 
       RER_RER_ORCRXERXRRXC ret = null;
       try {
          ret = (RER_RER_ORCRXERXRRXC)this.get("ORCRXERXRRXC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ORCRXERXRRXC (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public RER_RER_ORCRXERXRRXC getORCRXERXRRXC(int rep) { 
       RER_RER_ORCRXERXRRXC ret = null;
       try {
          ret = (RER_RER_ORCRXERXRRXC)this.get("ORCRXERXRRXC", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ORCRXERXRRXC 
     */ 
    public int getORCRXERXRRXCReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ORCRXERXRRXC").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ORCRXERXRRXC (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertORCRXERXRRXC(RER_RER_ORCRXERXRRXC structure, int rep) throws HL7Exception { 
       super.insertRepetition("ORCRXERXRRXC", structure, rep);
    }


    /**
     * Inserts a specific repetition of ORCRXERXRRXC (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public RER_RER_ORCRXERXRRXC insertORCRXERXRRXC(int rep) throws HL7Exception { 
       return (RER_RER_ORCRXERXRRXC)super.insertRepetition("ORCRXERXRRXC", rep);
    }


    /**
     * Removes a specific repetition of ORCRXERXRRXC (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public RER_RER_ORCRXERXRRXC removeORCRXERXRRXC(int rep) throws HL7Exception { 
       return (RER_RER_ORCRXERXRRXC)super.removeRepetition("ORCRXERXRRXC", rep);
    }



}

