/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a RGV_O01_ORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: ORC (ORC - common order segment) <b> </b></li>
                 * <li>2: RGV_O01_RXONTERXRRXCNTE (a Group object) <b>optional </b></li>
                 * <li>3: RGV_O01_RXERXRRXC (a Group object) <b>optional </b></li>
                 * <li>4: RGV_O01_RXGRXRRXCOBXNTE (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class RGV_O01_ORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE extends AbstractGroup {

    /** 
     * Creates a new RGV_O01_ORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE group
     */
    public RGV_O01_ORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(ORC.class, true, false);
                          this.add(RGV_O01_RXONTERXRRXCNTE.class, false, false);
                          this.add(RGV_O01_RXERXRRXC.class, false, false);
                          this.add(RGV_O01_RXGRXRRXCOBXNTE.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RGV_O01_ORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * ORC (ORC - common order segment) - creates it if necessary
     */
    public ORC getORC() { 
       ORC ret = null;
       try {
          ret = (ORC)this.get("ORC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * RXONTERXRRXCNTE (a Group object) - creates it if necessary
     */
    public RGV_O01_RXONTERXRRXCNTE getRXONTERXRRXCNTE() { 
       RGV_O01_RXONTERXRRXCNTE ret = null;
       try {
          ret = (RGV_O01_RXONTERXRRXCNTE)this.get("RXONTERXRRXCNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * RXERXRRXC (a Group object) - creates it if necessary
     */
    public RGV_O01_RXERXRRXC getRXERXRRXC() { 
       RGV_O01_RXERXRRXC ret = null;
       try {
          ret = (RGV_O01_RXERXRRXC)this.get("RXERXRRXC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * RXGRXRRXCOBXNTE (a Group object) - creates it if necessary
     */
    public RGV_O01_RXGRXRRXCOBXNTE getRXGRXRRXCOBXNTE() { 
       RGV_O01_RXGRXRRXCOBXNTE ret = null;
       try {
          ret = (RGV_O01_RXGRXRRXCOBXNTE)this.get("RXGRXRRXCOBXNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * RXGRXRRXCOBXNTE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public RGV_O01_RXGRXRRXCOBXNTE getRXGRXRRXCOBXNTE(int rep) { 
       RGV_O01_RXGRXRRXCOBXNTE ret = null;
       try {
          ret = (RGV_O01_RXGRXRRXCOBXNTE)this.get("RXGRXRRXCOBXNTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of RXGRXRRXCOBXNTE 
     */ 
    public int getRXGRXRRXCOBXNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("RXGRXRRXCOBXNTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of RXGRXRRXCOBXNTE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertRXGRXRRXCOBXNTE(RGV_O01_RXGRXRRXCOBXNTE structure, int rep) throws HL7Exception { 
       super.insertRepetition("RXGRXRRXCOBXNTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of RXGRXRRXCOBXNTE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public RGV_O01_RXGRXRRXCOBXNTE insertRXGRXRRXCOBXNTE(int rep) throws HL7Exception { 
       return (RGV_O01_RXGRXRRXCOBXNTE)super.insertRepetition("RXGRXRRXCOBXNTE", rep);
    }


    /**
     * Removes a specific repetition of RXGRXRRXCOBXNTE (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public RGV_O01_RXGRXRRXCOBXNTE removeRXGRXRRXCOBXNTE(int rep) throws HL7Exception { 
       return (RGV_O01_RXGRXRRXCOBXNTE)super.removeRepetition("RXGRXRRXCOBXNTE", rep);
    }



}

