/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a RRA_O02_PIDNTEORCRXARXR group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: RRA_O02_PIDNTE (a Group object) <b>optional </b></li>
                 * <li>2: RRA_O02_ORCRXARXR (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class RRA_O02_PIDNTEORCRXARXR extends AbstractGroup {

    /** 
     * Creates a new RRA_O02_PIDNTEORCRXARXR group
     */
    public RRA_O02_PIDNTEORCRXARXR(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(RRA_O02_PIDNTE.class, false, false);
                          this.add(RRA_O02_ORCRXARXR.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RRA_O02_PIDNTEORCRXARXR - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * PIDNTE (a Group object) - creates it if necessary
     */
    public RRA_O02_PIDNTE getPIDNTE() { 
       RRA_O02_PIDNTE ret = null;
       try {
          ret = (RRA_O02_PIDNTE)this.get("PIDNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * ORCRXARXR (a Group object) - creates it if necessary
     */
    public RRA_O02_ORCRXARXR getORCRXARXR() { 
       RRA_O02_ORCRXARXR ret = null;
       try {
          ret = (RRA_O02_ORCRXARXR)this.get("ORCRXARXR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ORCRXARXR (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public RRA_O02_ORCRXARXR getORCRXARXR(int rep) { 
       RRA_O02_ORCRXARXR ret = null;
       try {
          ret = (RRA_O02_ORCRXARXR)this.get("ORCRXARXR", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ORCRXARXR 
     */ 
    public int getORCRXARXRReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ORCRXARXR").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ORCRXARXR (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertORCRXARXR(RRA_O02_ORCRXARXR structure, int rep) throws HL7Exception { 
       super.insertRepetition("ORCRXARXR", structure, rep);
    }


    /**
     * Inserts a specific repetition of ORCRXARXR (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public RRA_O02_ORCRXARXR insertORCRXARXR(int rep) throws HL7Exception { 
       return (RRA_O02_ORCRXARXR)super.insertRepetition("ORCRXARXR", rep);
    }


    /**
     * Removes a specific repetition of ORCRXARXR (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public RRA_O02_ORCRXARXR removeORCRXARXR(int rep) throws HL7Exception { 
       return (RRA_O02_ORCRXARXR)super.removeRepetition("ORCRXARXR", rep);
    }



}

