/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a RRO_O02_PIDNTEORCRXONTERXRRXCNTE group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: RRO_O02_PIDNTE (a Group object) <b>optional </b></li>
                 * <li>2: RRO_O02_ORCRXONTERXRRXCNTE (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class RRO_O02_PIDNTEORCRXONTERXRRXCNTE extends AbstractGroup {

    /** 
     * Creates a new RRO_O02_PIDNTEORCRXONTERXRRXCNTE group
     */
    public RRO_O02_PIDNTEORCRXONTERXRRXCNTE(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(RRO_O02_PIDNTE.class, false, false);
                          this.add(RRO_O02_ORCRXONTERXRRXCNTE.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RRO_O02_PIDNTEORCRXONTERXRRXCNTE - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * PIDNTE (a Group object) - creates it if necessary
     */
    public RRO_O02_PIDNTE getPIDNTE() { 
       RRO_O02_PIDNTE ret = null;
       try {
          ret = (RRO_O02_PIDNTE)this.get("PIDNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * ORCRXONTERXRRXCNTE (a Group object) - creates it if necessary
     */
    public RRO_O02_ORCRXONTERXRRXCNTE getORCRXONTERXRRXCNTE() { 
       RRO_O02_ORCRXONTERXRRXCNTE ret = null;
       try {
          ret = (RRO_O02_ORCRXONTERXRRXCNTE)this.get("ORCRXONTERXRRXCNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ORCRXONTERXRRXCNTE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public RRO_O02_ORCRXONTERXRRXCNTE getORCRXONTERXRRXCNTE(int rep) { 
       RRO_O02_ORCRXONTERXRRXCNTE ret = null;
       try {
          ret = (RRO_O02_ORCRXONTERXRRXCNTE)this.get("ORCRXONTERXRRXCNTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ORCRXONTERXRRXCNTE 
     */ 
    public int getORCRXONTERXRRXCNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ORCRXONTERXRRXCNTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ORCRXONTERXRRXCNTE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertORCRXONTERXRRXCNTE(RRO_O02_ORCRXONTERXRRXCNTE structure, int rep) throws HL7Exception { 
       super.insertRepetition("ORCRXONTERXRRXCNTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of ORCRXONTERXRRXCNTE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public RRO_O02_ORCRXONTERXRRXCNTE insertORCRXONTERXRRXCNTE(int rep) throws HL7Exception { 
       return (RRO_O02_ORCRXONTERXRRXCNTE)super.insertRepetition("ORCRXONTERXRRXCNTE", rep);
    }


    /**
     * Removes a specific repetition of ORCRXONTERXRRXCNTE (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public RRO_O02_ORCRXONTERXRRXCNTE removeORCRXONTERXRRXCNTE(int rep) throws HL7Exception { 
       return (RRO_O02_ORCRXONTERXRRXCNTE)super.removeRepetition("ORCRXONTERXRRXCNTE", rep);
    }



}

