/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a SQM_S25_RGSAISAPRAIGAPRAIPAPRAILAPR group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: RGS (RGS - resource group segment) <b> </b></li>
                 * <li>2: SQM_S25_AISAPR (a Group object) <b>optional repeating</b></li>
                 * <li>3: SQM_S25_AIGAPR (a Group object) <b>optional repeating</b></li>
                 * <li>4: SQM_S25_AIPAPR (a Group object) <b>optional repeating</b></li>
                 * <li>5: SQM_S25_AILAPR (a Group object) <b>optional repeating</b></li>
 * </ul>
 */
public class SQM_S25_RGSAISAPRAIGAPRAIPAPRAILAPR extends AbstractGroup {

    /** 
     * Creates a new SQM_S25_RGSAISAPRAIGAPRAIPAPRAILAPR group
     */
    public SQM_S25_RGSAISAPRAIGAPRAIPAPRAILAPR(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(RGS.class, true, false);
                          this.add(SQM_S25_AISAPR.class, false, true);
                          this.add(SQM_S25_AIGAPR.class, false, true);
                          this.add(SQM_S25_AIPAPR.class, false, true);
                          this.add(SQM_S25_AILAPR.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating SQM_S25_RGSAISAPRAIGAPRAIPAPRAILAPR - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * RGS (RGS - resource group segment) - creates it if necessary
     */
    public RGS getRGS() { 
       RGS ret = null;
       try {
          ret = (RGS)this.get("RGS");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * AISAPR (a Group object) - creates it if necessary
     */
    public SQM_S25_AISAPR getAISAPR() { 
       SQM_S25_AISAPR ret = null;
       try {
          ret = (SQM_S25_AISAPR)this.get("AISAPR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * AISAPR (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SQM_S25_AISAPR getAISAPR(int rep) { 
       SQM_S25_AISAPR ret = null;
       try {
          ret = (SQM_S25_AISAPR)this.get("AISAPR", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of AISAPR 
     */ 
    public int getAISAPRReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("AISAPR").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of AISAPR (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertAISAPR(SQM_S25_AISAPR structure, int rep) throws HL7Exception { 
       super.insertRepetition("AISAPR", structure, rep);
    }


    /**
     * Inserts a specific repetition of AISAPR (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public SQM_S25_AISAPR insertAISAPR(int rep) throws HL7Exception { 
       return (SQM_S25_AISAPR)super.insertRepetition("AISAPR", rep);
    }


    /**
     * Removes a specific repetition of AISAPR (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public SQM_S25_AISAPR removeAISAPR(int rep) throws HL7Exception { 
       return (SQM_S25_AISAPR)super.removeRepetition("AISAPR", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * AIGAPR (a Group object) - creates it if necessary
     */
    public SQM_S25_AIGAPR getAIGAPR() { 
       SQM_S25_AIGAPR ret = null;
       try {
          ret = (SQM_S25_AIGAPR)this.get("AIGAPR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * AIGAPR (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SQM_S25_AIGAPR getAIGAPR(int rep) { 
       SQM_S25_AIGAPR ret = null;
       try {
          ret = (SQM_S25_AIGAPR)this.get("AIGAPR", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of AIGAPR 
     */ 
    public int getAIGAPRReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("AIGAPR").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of AIGAPR (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertAIGAPR(SQM_S25_AIGAPR structure, int rep) throws HL7Exception { 
       super.insertRepetition("AIGAPR", structure, rep);
    }


    /**
     * Inserts a specific repetition of AIGAPR (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public SQM_S25_AIGAPR insertAIGAPR(int rep) throws HL7Exception { 
       return (SQM_S25_AIGAPR)super.insertRepetition("AIGAPR", rep);
    }


    /**
     * Removes a specific repetition of AIGAPR (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public SQM_S25_AIGAPR removeAIGAPR(int rep) throws HL7Exception { 
       return (SQM_S25_AIGAPR)super.removeRepetition("AIGAPR", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * AIPAPR (a Group object) - creates it if necessary
     */
    public SQM_S25_AIPAPR getAIPAPR() { 
       SQM_S25_AIPAPR ret = null;
       try {
          ret = (SQM_S25_AIPAPR)this.get("AIPAPR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * AIPAPR (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SQM_S25_AIPAPR getAIPAPR(int rep) { 
       SQM_S25_AIPAPR ret = null;
       try {
          ret = (SQM_S25_AIPAPR)this.get("AIPAPR", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of AIPAPR 
     */ 
    public int getAIPAPRReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("AIPAPR").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of AIPAPR (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertAIPAPR(SQM_S25_AIPAPR structure, int rep) throws HL7Exception { 
       super.insertRepetition("AIPAPR", structure, rep);
    }


    /**
     * Inserts a specific repetition of AIPAPR (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public SQM_S25_AIPAPR insertAIPAPR(int rep) throws HL7Exception { 
       return (SQM_S25_AIPAPR)super.insertRepetition("AIPAPR", rep);
    }


    /**
     * Removes a specific repetition of AIPAPR (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public SQM_S25_AIPAPR removeAIPAPR(int rep) throws HL7Exception { 
       return (SQM_S25_AIPAPR)super.removeRepetition("AIPAPR", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * AILAPR (a Group object) - creates it if necessary
     */
    public SQM_S25_AILAPR getAILAPR() { 
       SQM_S25_AILAPR ret = null;
       try {
          ret = (SQM_S25_AILAPR)this.get("AILAPR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * AILAPR (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SQM_S25_AILAPR getAILAPR(int rep) { 
       SQM_S25_AILAPR ret = null;
       try {
          ret = (SQM_S25_AILAPR)this.get("AILAPR", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of AILAPR 
     */ 
    public int getAILAPRReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("AILAPR").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of AILAPR (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertAILAPR(SQM_S25_AILAPR structure, int rep) throws HL7Exception { 
       super.insertRepetition("AILAPR", structure, rep);
    }


    /**
     * Inserts a specific repetition of AILAPR (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public SQM_S25_AILAPR insertAILAPR(int rep) throws HL7Exception { 
       return (SQM_S25_AILAPR)super.insertRepetition("AILAPR", rep);
    }


    /**
     * Removes a specific repetition of AILAPR (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public SQM_S25_AILAPR removeAILAPR(int rep) throws HL7Exception { 
       return (SQM_S25_AILAPR)super.removeRepetition("AILAPR", rep);
    }



}

