/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a SQR_S25_RGSAISNTEAIGNTEAIPNTEAILNTE group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: RGS (RGS - resource group segment) <b> </b></li>
                 * <li>2: SQR_S25_AISNTE (a Group object) <b>optional repeating</b></li>
                 * <li>3: SQR_S25_AIGNTE (a Group object) <b>optional repeating</b></li>
                 * <li>4: SQR_S25_AIPNTE (a Group object) <b>optional repeating</b></li>
                 * <li>5: SQR_S25_AILNTE (a Group object) <b>optional repeating</b></li>
 * </ul>
 */
public class SQR_S25_RGSAISNTEAIGNTEAIPNTEAILNTE extends AbstractGroup {

    /** 
     * Creates a new SQR_S25_RGSAISNTEAIGNTEAIPNTEAILNTE group
     */
    public SQR_S25_RGSAISNTEAIGNTEAIPNTEAILNTE(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(RGS.class, true, false);
                          this.add(SQR_S25_AISNTE.class, false, true);
                          this.add(SQR_S25_AIGNTE.class, false, true);
                          this.add(SQR_S25_AIPNTE.class, false, true);
                          this.add(SQR_S25_AILNTE.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating SQR_S25_RGSAISNTEAIGNTEAIPNTEAILNTE - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * RGS (RGS - resource group segment) - creates it if necessary
     */
    public RGS getRGS() { 
       RGS ret = null;
       try {
          ret = (RGS)this.get("RGS");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * AISNTE (a Group object) - creates it if necessary
     */
    public SQR_S25_AISNTE getAISNTE() { 
       SQR_S25_AISNTE ret = null;
       try {
          ret = (SQR_S25_AISNTE)this.get("AISNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * AISNTE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SQR_S25_AISNTE getAISNTE(int rep) { 
       SQR_S25_AISNTE ret = null;
       try {
          ret = (SQR_S25_AISNTE)this.get("AISNTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of AISNTE 
     */ 
    public int getAISNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("AISNTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of AISNTE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertAISNTE(SQR_S25_AISNTE structure, int rep) throws HL7Exception { 
       super.insertRepetition("AISNTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of AISNTE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public SQR_S25_AISNTE insertAISNTE(int rep) throws HL7Exception { 
       return (SQR_S25_AISNTE)super.insertRepetition("AISNTE", rep);
    }


    /**
     * Removes a specific repetition of AISNTE (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public SQR_S25_AISNTE removeAISNTE(int rep) throws HL7Exception { 
       return (SQR_S25_AISNTE)super.removeRepetition("AISNTE", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * AIGNTE (a Group object) - creates it if necessary
     */
    public SQR_S25_AIGNTE getAIGNTE() { 
       SQR_S25_AIGNTE ret = null;
       try {
          ret = (SQR_S25_AIGNTE)this.get("AIGNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * AIGNTE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SQR_S25_AIGNTE getAIGNTE(int rep) { 
       SQR_S25_AIGNTE ret = null;
       try {
          ret = (SQR_S25_AIGNTE)this.get("AIGNTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of AIGNTE 
     */ 
    public int getAIGNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("AIGNTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of AIGNTE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertAIGNTE(SQR_S25_AIGNTE structure, int rep) throws HL7Exception { 
       super.insertRepetition("AIGNTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of AIGNTE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public SQR_S25_AIGNTE insertAIGNTE(int rep) throws HL7Exception { 
       return (SQR_S25_AIGNTE)super.insertRepetition("AIGNTE", rep);
    }


    /**
     * Removes a specific repetition of AIGNTE (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public SQR_S25_AIGNTE removeAIGNTE(int rep) throws HL7Exception { 
       return (SQR_S25_AIGNTE)super.removeRepetition("AIGNTE", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * AIPNTE (a Group object) - creates it if necessary
     */
    public SQR_S25_AIPNTE getAIPNTE() { 
       SQR_S25_AIPNTE ret = null;
       try {
          ret = (SQR_S25_AIPNTE)this.get("AIPNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * AIPNTE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SQR_S25_AIPNTE getAIPNTE(int rep) { 
       SQR_S25_AIPNTE ret = null;
       try {
          ret = (SQR_S25_AIPNTE)this.get("AIPNTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of AIPNTE 
     */ 
    public int getAIPNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("AIPNTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of AIPNTE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertAIPNTE(SQR_S25_AIPNTE structure, int rep) throws HL7Exception { 
       super.insertRepetition("AIPNTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of AIPNTE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public SQR_S25_AIPNTE insertAIPNTE(int rep) throws HL7Exception { 
       return (SQR_S25_AIPNTE)super.insertRepetition("AIPNTE", rep);
    }


    /**
     * Removes a specific repetition of AIPNTE (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public SQR_S25_AIPNTE removeAIPNTE(int rep) throws HL7Exception { 
       return (SQR_S25_AIPNTE)super.removeRepetition("AIPNTE", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * AILNTE (a Group object) - creates it if necessary
     */
    public SQR_S25_AILNTE getAILNTE() { 
       SQR_S25_AILNTE ret = null;
       try {
          ret = (SQR_S25_AILNTE)this.get("AILNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * AILNTE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SQR_S25_AILNTE getAILNTE(int rep) { 
       SQR_S25_AILNTE ret = null;
       try {
          ret = (SQR_S25_AILNTE)this.get("AILNTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of AILNTE 
     */ 
    public int getAILNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("AILNTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of AILNTE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertAILNTE(SQR_S25_AILNTE structure, int rep) throws HL7Exception { 
       super.insertRepetition("AILNTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of AILNTE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public SQR_S25_AILNTE insertAILNTE(int rep) throws HL7Exception { 
       return (SQR_S25_AILNTE)super.insertRepetition("AILNTE", rep);
    }


    /**
     * Removes a specific repetition of AILNTE (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public SQR_S25_AILNTE removeAILNTE(int rep) throws HL7Exception { 
       return (SQR_S25_AILNTE)super.removeRepetition("AILNTE", rep);
    }



}

