/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: RGS (RGS - resource group segment) <b> </b></li>
                 * <li>2: SRM_S01_AISAPRNTE (a Group object) <b>optional repeating</b></li>
                 * <li>3: SRM_S01_AIGAPRNTE (a Group object) <b>optional repeating</b></li>
                 * <li>4: SRM_S01_AILAPRNTE (a Group object) <b>optional repeating</b></li>
                 * <li>5: SRM_S01_AIPAPRNTE (a Group object) <b>optional repeating</b></li>
 * </ul>
 */
public class SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE extends AbstractGroup {

    /** 
     * Creates a new SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE group
     */
    public SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(RGS.class, true, false);
                          this.add(SRM_S01_AISAPRNTE.class, false, true);
                          this.add(SRM_S01_AIGAPRNTE.class, false, true);
                          this.add(SRM_S01_AILAPRNTE.class, false, true);
                          this.add(SRM_S01_AIPAPRNTE.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * RGS (RGS - resource group segment) - creates it if necessary
     */
    public RGS getRGS() { 
       RGS ret = null;
       try {
          ret = (RGS)this.get("RGS");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * AISAPRNTE (a Group object) - creates it if necessary
     */
    public SRM_S01_AISAPRNTE getAISAPRNTE() { 
       SRM_S01_AISAPRNTE ret = null;
       try {
          ret = (SRM_S01_AISAPRNTE)this.get("AISAPRNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * AISAPRNTE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SRM_S01_AISAPRNTE getAISAPRNTE(int rep) { 
       SRM_S01_AISAPRNTE ret = null;
       try {
          ret = (SRM_S01_AISAPRNTE)this.get("AISAPRNTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of AISAPRNTE 
     */ 
    public int getAISAPRNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("AISAPRNTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of AISAPRNTE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertAISAPRNTE(SRM_S01_AISAPRNTE structure, int rep) throws HL7Exception { 
       super.insertRepetition("AISAPRNTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of AISAPRNTE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public SRM_S01_AISAPRNTE insertAISAPRNTE(int rep) throws HL7Exception { 
       return (SRM_S01_AISAPRNTE)super.insertRepetition("AISAPRNTE", rep);
    }


    /**
     * Removes a specific repetition of AISAPRNTE (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public SRM_S01_AISAPRNTE removeAISAPRNTE(int rep) throws HL7Exception { 
       return (SRM_S01_AISAPRNTE)super.removeRepetition("AISAPRNTE", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * AIGAPRNTE (a Group object) - creates it if necessary
     */
    public SRM_S01_AIGAPRNTE getAIGAPRNTE() { 
       SRM_S01_AIGAPRNTE ret = null;
       try {
          ret = (SRM_S01_AIGAPRNTE)this.get("AIGAPRNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * AIGAPRNTE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SRM_S01_AIGAPRNTE getAIGAPRNTE(int rep) { 
       SRM_S01_AIGAPRNTE ret = null;
       try {
          ret = (SRM_S01_AIGAPRNTE)this.get("AIGAPRNTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of AIGAPRNTE 
     */ 
    public int getAIGAPRNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("AIGAPRNTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of AIGAPRNTE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertAIGAPRNTE(SRM_S01_AIGAPRNTE structure, int rep) throws HL7Exception { 
       super.insertRepetition("AIGAPRNTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of AIGAPRNTE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public SRM_S01_AIGAPRNTE insertAIGAPRNTE(int rep) throws HL7Exception { 
       return (SRM_S01_AIGAPRNTE)super.insertRepetition("AIGAPRNTE", rep);
    }


    /**
     * Removes a specific repetition of AIGAPRNTE (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public SRM_S01_AIGAPRNTE removeAIGAPRNTE(int rep) throws HL7Exception { 
       return (SRM_S01_AIGAPRNTE)super.removeRepetition("AIGAPRNTE", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * AILAPRNTE (a Group object) - creates it if necessary
     */
    public SRM_S01_AILAPRNTE getAILAPRNTE() { 
       SRM_S01_AILAPRNTE ret = null;
       try {
          ret = (SRM_S01_AILAPRNTE)this.get("AILAPRNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * AILAPRNTE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SRM_S01_AILAPRNTE getAILAPRNTE(int rep) { 
       SRM_S01_AILAPRNTE ret = null;
       try {
          ret = (SRM_S01_AILAPRNTE)this.get("AILAPRNTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of AILAPRNTE 
     */ 
    public int getAILAPRNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("AILAPRNTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of AILAPRNTE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertAILAPRNTE(SRM_S01_AILAPRNTE structure, int rep) throws HL7Exception { 
       super.insertRepetition("AILAPRNTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of AILAPRNTE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public SRM_S01_AILAPRNTE insertAILAPRNTE(int rep) throws HL7Exception { 
       return (SRM_S01_AILAPRNTE)super.insertRepetition("AILAPRNTE", rep);
    }


    /**
     * Removes a specific repetition of AILAPRNTE (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public SRM_S01_AILAPRNTE removeAILAPRNTE(int rep) throws HL7Exception { 
       return (SRM_S01_AILAPRNTE)super.removeRepetition("AILAPRNTE", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * AIPAPRNTE (a Group object) - creates it if necessary
     */
    public SRM_S01_AIPAPRNTE getAIPAPRNTE() { 
       SRM_S01_AIPAPRNTE ret = null;
       try {
          ret = (SRM_S01_AIPAPRNTE)this.get("AIPAPRNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * AIPAPRNTE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SRM_S01_AIPAPRNTE getAIPAPRNTE(int rep) { 
       SRM_S01_AIPAPRNTE ret = null;
       try {
          ret = (SRM_S01_AIPAPRNTE)this.get("AIPAPRNTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of AIPAPRNTE 
     */ 
    public int getAIPAPRNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("AIPAPRNTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of AIPAPRNTE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertAIPAPRNTE(SRM_S01_AIPAPRNTE structure, int rep) throws HL7Exception { 
       super.insertRepetition("AIPAPRNTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of AIPAPRNTE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public SRM_S01_AIPAPRNTE insertAIPAPRNTE(int rep) throws HL7Exception { 
       return (SRM_S01_AIPAPRNTE)super.insertRepetition("AIPAPRNTE", rep);
    }


    /**
     * Removes a specific repetition of AIPAPRNTE (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public SRM_S01_AIPAPRNTE removeAIPAPRNTE(int rep) throws HL7Exception { 
       return (SRM_S01_AIPAPRNTE)super.removeRepetition("AIPAPRNTE", rep);
    }



}

