/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a SRR_S01_SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAILNTEAIPNTE group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: SCH (SCH - schedule activity information segment) <b> </b></li>
                 * <li>2: NTE (NTE - notes and comments segment) <b>optional repeating</b></li>
                 * <li>3: SRR_S01_PIDPV1PV2DG1 (a Group object) <b>optional repeating</b></li>
                 * <li>4: SRR_S01_RGSAISNTEAIGNTEAILNTEAIPNTE (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class SRR_S01_SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAILNTEAIPNTE extends AbstractGroup {

    /** 
     * Creates a new SRR_S01_SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAILNTEAIPNTE group
     */
    public SRR_S01_SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAILNTEAIPNTE(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(SCH.class, true, false);
                          this.add(NTE.class, false, true);
                          this.add(SRR_S01_PIDPV1PV2DG1.class, false, true);
                          this.add(SRR_S01_RGSAISNTEAIGNTEAILNTEAIPNTE.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating SRR_S01_SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAILNTEAIPNTE - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * SCH (SCH - schedule activity information segment) - creates it if necessary
     */
    public SCH getSCH() { 
       SCH ret = null;
       try {
          ret = (SCH)this.get("SCH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * NTE (NTE - notes and comments segment) - creates it if necessary
     */
    public NTE getNTE() { 
       NTE ret = null;
       try {
          ret = (NTE)this.get("NTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * NTE (NTE - notes and comments segment) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public NTE getNTE(int rep) { 
       NTE ret = null;
       try {
          ret = (NTE)this.get("NTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of NTE 
     */ 
    public int getNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("NTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of NTE (NTE - notes and comments segment)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertNTE(NTE structure, int rep) throws HL7Exception { 
       super.insertRepetition("NTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of NTE (NTE - notes and comments segment)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public NTE insertNTE(int rep) throws HL7Exception { 
       return (NTE)super.insertRepetition("NTE", rep);
    }


    /**
     * Removes a specific repetition of NTE (NTE - notes and comments segment)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public NTE removeNTE(int rep) throws HL7Exception { 
       return (NTE)super.removeRepetition("NTE", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * PIDPV1PV2DG1 (a Group object) - creates it if necessary
     */
    public SRR_S01_PIDPV1PV2DG1 getPIDPV1PV2DG1() { 
       SRR_S01_PIDPV1PV2DG1 ret = null;
       try {
          ret = (SRR_S01_PIDPV1PV2DG1)this.get("PIDPV1PV2DG1");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * PIDPV1PV2DG1 (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SRR_S01_PIDPV1PV2DG1 getPIDPV1PV2DG1(int rep) { 
       SRR_S01_PIDPV1PV2DG1 ret = null;
       try {
          ret = (SRR_S01_PIDPV1PV2DG1)this.get("PIDPV1PV2DG1", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of PIDPV1PV2DG1 
     */ 
    public int getPIDPV1PV2DG1Reps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("PIDPV1PV2DG1").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of PIDPV1PV2DG1 (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertPIDPV1PV2DG1(SRR_S01_PIDPV1PV2DG1 structure, int rep) throws HL7Exception { 
       super.insertRepetition("PIDPV1PV2DG1", structure, rep);
    }


    /**
     * Inserts a specific repetition of PIDPV1PV2DG1 (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public SRR_S01_PIDPV1PV2DG1 insertPIDPV1PV2DG1(int rep) throws HL7Exception { 
       return (SRR_S01_PIDPV1PV2DG1)super.insertRepetition("PIDPV1PV2DG1", rep);
    }


    /**
     * Removes a specific repetition of PIDPV1PV2DG1 (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public SRR_S01_PIDPV1PV2DG1 removePIDPV1PV2DG1(int rep) throws HL7Exception { 
       return (SRR_S01_PIDPV1PV2DG1)super.removeRepetition("PIDPV1PV2DG1", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * RGSAISNTEAIGNTEAILNTEAIPNTE (a Group object) - creates it if necessary
     */
    public SRR_S01_RGSAISNTEAIGNTEAILNTEAIPNTE getRGSAISNTEAIGNTEAILNTEAIPNTE() { 
       SRR_S01_RGSAISNTEAIGNTEAILNTEAIPNTE ret = null;
       try {
          ret = (SRR_S01_RGSAISNTEAIGNTEAILNTEAIPNTE)this.get("RGSAISNTEAIGNTEAILNTEAIPNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * RGSAISNTEAIGNTEAILNTEAIPNTE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SRR_S01_RGSAISNTEAIGNTEAILNTEAIPNTE getRGSAISNTEAIGNTEAILNTEAIPNTE(int rep) { 
       SRR_S01_RGSAISNTEAIGNTEAILNTEAIPNTE ret = null;
       try {
          ret = (SRR_S01_RGSAISNTEAIGNTEAILNTEAIPNTE)this.get("RGSAISNTEAIGNTEAILNTEAIPNTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of RGSAISNTEAIGNTEAILNTEAIPNTE 
     */ 
    public int getRGSAISNTEAIGNTEAILNTEAIPNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("RGSAISNTEAIGNTEAILNTEAIPNTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of RGSAISNTEAIGNTEAILNTEAIPNTE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertRGSAISNTEAIGNTEAILNTEAIPNTE(SRR_S01_RGSAISNTEAIGNTEAILNTEAIPNTE structure, int rep) throws HL7Exception { 
       super.insertRepetition("RGSAISNTEAIGNTEAILNTEAIPNTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of RGSAISNTEAIGNTEAILNTEAIPNTE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public SRR_S01_RGSAISNTEAIGNTEAILNTEAIPNTE insertRGSAISNTEAIGNTEAILNTEAIPNTE(int rep) throws HL7Exception { 
       return (SRR_S01_RGSAISNTEAIGNTEAILNTEAIPNTE)super.insertRepetition("RGSAISNTEAIGNTEAILNTEAIPNTE", rep);
    }


    /**
     * Removes a specific repetition of RGSAISNTEAIGNTEAILNTEAIPNTE (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public SRR_S01_RGSAISNTEAIGNTEAILNTEAIPNTE removeRGSAISNTEAIGNTEAILNTEAIPNTE(int rep) throws HL7Exception { 
       return (SRR_S01_RGSAISNTEAIGNTEAILNTEAIPNTE)super.removeRepetition("RGSAISNTEAIGNTEAILNTEAIPNTE", rep);
    }



}

